/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.serialization;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;

public class ProtostuffExample
implements Example {
    public static void main(String[] args) throws Exception {
        new ProtostuffExample().run();
    }

    @Override
    public String command() {
        return "protostuff";
    }

    @Override
    public String description() {
        return "serialize a Random Cut Forest with the protostuff library";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        byte[] bytes;
        int dimensions = 10;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).build();
        int dataSize = 1000 * sampleSize;
        NormalMixtureTestData testData = new NormalMixtureTestData();
        for (double[] point : testData.generateTestData(dataSize, dimensions)) {
            forest.update(point);
        }
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        Schema schema = RuntimeSchema.getSchema(RandomCutForestState.class);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            RandomCutForestState state = mapper.toState(forest);
            bytes = ProtostuffIOUtil.toByteArray((Object)state, (Schema)schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        System.out.printf("dimensions = %d, numberOfTrees = %d, sampleSize = %d, precision = %s%n", dimensions, numberOfTrees, sampleSize, precision);
        System.out.printf("protostuff size = %d bytes%n", bytes.length);
        RandomCutForestState state2 = (RandomCutForestState)schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)state2, (Schema)schema);
        RandomCutForest forest2 = mapper.toModel(state2);
        int testSize = 100;
        double delta = Math.log(sampleSize) / Math.log(2.0) * 0.05;
        int differences = 0;
        int anomalies = 0;
        for (double[] point : testData.generateTestData(testSize, dimensions)) {
            double score = forest.getAnomalyScore(point);
            double score2 = forest2.getAnomalyScore(point);
            if (score > 1.0 || score2 > 1.0) {
                ++anomalies;
                if (Math.abs(score - score2) > delta) {
                    ++differences;
                }
            }
            forest.update(point);
            forest2.update(point);
        }
        if (anomalies == 0) {
            throw new IllegalStateException("test data did not produce any anomalies");
        }
        if ((double)differences >= 0.01 * (double)testSize) {
            throw new IllegalStateException("restored forest does not agree with original forest");
        }
        System.out.println("Looks good!");
    }
}

