/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import com.amazon.randomcutforest.util.Weighted;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;

public class RCFMultiSummarizeExample
implements Example {
    public static void main(String[] args) throws Exception {
        new RCFMultiSummarizeExample().run();
    }

    @Override
    public String command() {
        return "RCF_Multi_Summarize_Example";
    }

    @Override
    public String description() {
        return "Example of using RCF Multi Summarization";
    }

    @Override
    public void run() throws Exception {
        long seed = new Random().nextLong();
        Random random = new Random(seed);
        int newDimensions = random.nextInt(10) + 3;
        int dataSize = 200000;
        float[][] points = this.getData(dataSize, newDimensions, random.nextInt(), Summarizer::L2distance);
        double epsilon = 0.01;
        List summary = Summarizer.multiSummarize((float[][])points, (int)(5 * newDimensions), (double)0.1, (int)5);
        System.out.println(summary.size() + " clusters for " + newDimensions + " dimensions, seed : " + seed);
        double weight = summary.stream().map(e -> e.getWeight()).reduce(Double::sum).get();
        System.out.println("Total weight " + (double)Math.round(weight * 1000.0) * 0.001 + " rounding to multiples of " + epsilon);
        System.out.println();
        for (int i = 0; i < summary.size(); ++i) {
            double clusterWeight = ((ICluster)summary.get(i)).getWeight();
            System.out.println("Cluster " + i + " representatives, weight " + (double)Math.round(1000.0 * clusterWeight) * 0.001);
            List representatives = ((ICluster)summary.get(i)).getRepresentatives();
            for (int j = 0; j < representatives.size(); ++j) {
                double t = ((Weighted)representatives.get((int)j)).weight;
                t = (double)Math.round(1000.0 * t / clusterWeight) * 0.001;
                System.out.print("relative weight " + (float)t + " center (approx)  ");
                this.printArray((float[])((Weighted)representatives.get((int)j)).index, epsilon);
                System.out.println();
            }
            System.out.println();
        }
    }

    void printArray(float[] values, double epsilon) {
        System.out.print(" [");
        if ((double)Math.abs(values[0]) < epsilon) {
            System.out.print("0");
        } else if (epsilon <= 0.0) {
            System.out.print(values[0]);
        } else {
            long t = (int)Math.round((double)values[0] / epsilon);
            System.out.print((double)t * epsilon);
        }
        for (int i = 1; i < values.length; ++i) {
            if ((double)Math.abs(values[i]) < epsilon) {
                System.out.print(", 0");
                continue;
            }
            if (epsilon <= 0.0) {
                System.out.print(", " + values[i]);
                continue;
            }
            long t = Math.round((double)values[i] / epsilon);
            System.out.print(", " + (double)t * epsilon);
        }
        System.out.print("]");
    }

    public float[][] getData(int dataSize, int newDimensions, int seed, BiFunction<float[], float[], Double> distance) {
        double baseMu = 0.0;
        double baseSigma = 1.0;
        double anomalyMu = 0.0;
        double anomalySigma = 1.0;
        double transitionToAnomalyProbability = 0.0;
        double transitionToBaseProbability = 1.0;
        Random prg = new Random(0L);
        NormalMixtureTestData generator = new NormalMixtureTestData(baseMu, baseSigma, anomalyMu, anomalySigma, transitionToAnomalyProbability, transitionToBaseProbability);
        double[][] data = generator.generateTestData(dataSize, newDimensions, seed);
        float[][] floatData = new float[dataSize][];
        float[] allZero = new float[newDimensions];
        float[] sigma = new float[newDimensions];
        Arrays.fill(sigma, 1.0f);
        double scale = distance.apply(allZero, sigma);
        for (int i = 0; i < dataSize; ++i) {
            int nextD = prg.nextInt(newDimensions);
            for (int j = 0; j < newDimensions; ++j) {
                double[] dArray = data[i];
                int n = j;
                dArray[n] = dArray[n] * 0.3333333333333333;
                if (j != nextD) continue;
                if (prg.nextDouble() < 0.5) {
                    double[] dArray2 = data[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + 2.0 * scale;
                    continue;
                }
                double[] dArray3 = data[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] - 2.0 * scale;
            }
            floatData[i] = CommonUtils.toFloatArray((double[])data[i]);
        }
        return floatData;
    }
}

