/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.RCFCaster;
import com.amazon.randomcutforest.parkservices.calibration.Calibration;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class RCFCasterExample
implements Example {
    public static void main(String[] args) throws Exception {
        new RCFCasterExample().run();
    }

    @Override
    public String command() {
        return "Calibrated RCFCast";
    }

    @Override
    public String description() {
        return "Calibrated RCFCast Example";
    }

    @Override
    public void run() throws Exception {
        int j;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 2 * sampleSize;
        int baseDimensions = 2;
        int forecastHorizon = 15;
        int shingleSize = 20;
        int outputAfter = 64;
        long seed = 2023L;
        double[][] fulldata = new double[2 * dataSize][];
        double shiftForViz = 200.0;
        System.out.println("seed = " + seed);
        MultiDimDataWithKey dataWithKeys = ShingledMultiDimDataWithKeys.getMultiDimData((int)dataSize, (int)50, (double)50.0, (double)5.0, (long)seed, (int)baseDimensions, (boolean)true);
        for (int i = 0; i < dataSize; ++i) {
            fulldata[i] = Arrays.copyOf(dataWithKeys.data[i], baseDimensions);
            double[] dArray = fulldata[i];
            dArray[0] = dArray[0] + shiftForViz;
        }
        MultiDimDataWithKey second = ShingledMultiDimDataWithKeys.getMultiDimData((int)dataSize, (int)70, (double)30.0, (double)5.0, (long)(seed + 1L), (int)baseDimensions, (boolean)true);
        for (int i = 0; i < dataSize; ++i) {
            fulldata[dataSize + i] = Arrays.copyOf(second.data[i], baseDimensions);
            double[] dArray = fulldata[dataSize + i];
            dArray[0] = dArray[0] + shiftForViz;
        }
        int dimensions = baseDimensions * shingleSize;
        TransformMethod transformMethod = TransformMethod.NORMALIZE;
        RCFCaster caster = ((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)RCFCaster.builder().dimensions(dimensions)).randomSeed(seed + 1L)).numberOfTrees(numberOfTrees)).shingleSize(shingleSize)).sampleSize(sampleSize)).internalShinglingEnabled(true)).precision(precision)).anomalyRate(0.01)).outputAfter(outputAfter)).calibration(Calibration.MINIMAL).transformDecay(0.02)).forecastHorizon(forecastHorizon).initialAcceptFraction(0.125)).build();
        String name = "example";
        BufferedWriter file = new BufferedWriter(new FileWriter(name));
        for (j = 0; j < fulldata.length; ++j) {
            file.append(j + " ");
            for (int k = 0; k < baseDimensions; ++k) {
                file.append(fulldata[j][k] + " ");
            }
            file.append("\n");
        }
        file.append("\n");
        file.append("\n");
        for (j = 0; j < fulldata.length; ++j) {
            ForecastDescriptor result = caster.process(fulldata[j], 0L);
            this.printResult(file, result, j, baseDimensions);
        }
        file.close();
    }

    void printResult(BufferedWriter file, ForecastDescriptor result, int current, int inputLength) throws IOException {
        int k;
        int j;
        int i;
        RangeVector forecast = result.getTimedForecast().rangeVector;
        float[] errorP50 = result.getObservedErrorDistribution().values;
        float[] upperError = result.getObservedErrorDistribution().upper;
        float[] lowerError = result.getObservedErrorDistribution().lower;
        DiVector rmse = result.getErrorRMSE();
        float[] mean = result.getErrorMean();
        float[] intervalPrecision = result.getIntervalPrecision();
        file.append(current + " " + 1000 + "\n");
        file.append("\n");
        file.append("\n");
        for (i = forecast.values.length / inputLength - 1; i >= 0; --i) {
            file.append(current - i + " ");
            for (j = 0; j < inputLength; ++j) {
                k = i * inputLength + j;
                file.append(mean[k] + " " + rmse.high[k] + " " + rmse.low[k] + " " + errorP50[k] + " " + upperError[k] + " " + lowerError[k] + " " + intervalPrecision[k] + " ");
            }
            file.append("\n");
        }
        file.append("\n");
        file.append("\n");
        for (i = 0; i < forecast.values.length / inputLength; ++i) {
            file.append(current + i + " ");
            for (j = 0; j < inputLength; ++j) {
                k = i * inputLength + j;
                file.append(forecast.values[k] + " " + forecast.upper[k] + " " + forecast.lower[k] + " ");
            }
            file.append("\n");
        }
        file.append("\n");
        file.append("\n");
    }
}

