/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import java.util.Random;

public class Thresholded1DGaussianMix
implements Example {
    public static void main(String[] args) throws Exception {
        new Thresholded1DGaussianMix().run();
    }

    @Override
    public String command() {
        return "Thresholded_1D_Gaussian_example";
    }

    @Override
    public String description() {
        return "Thresholded one dimensional gassian mixture Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 1;
        int count = 0;
        int dimensions = baseDimensions * shingleSize;
        ThresholdedRandomCutForest forest = new ThresholdedRandomCutForest.Builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).precision(precision).anomalyRate(0.01).forestMode(ForestMode.TIME_AUGMENTED).build();
        long seed = new Random().nextLong();
        System.out.println("Anomalies would correspond to a run, based on a change of state.");
        System.out.println("Each change is normal <-> anomaly;  so after the second change the data is normal");
        System.out.println("seed = " + seed);
        NormalMixtureTestData normalMixtureTestData = new NormalMixtureTestData(10.0, 1.0, 50.0, 2.0, 0.01, 0.1);
        MultiDimDataWithKey dataWithKeys = normalMixtureTestData.generateTestDataWithKey(dataSize, 1, 0);
        int keyCounter = 0;
        for (double[] point : dataWithKeys.data) {
            AnomalyDescriptor result = forest.process(point, (long)count);
            if (keyCounter < dataWithKeys.changeIndices.length && result.getInternalTimeStamp() == (long)dataWithKeys.changeIndices[keyCounter]) {
                System.out.println("timestamp " + result.getInputTimestamp() + " CHANGE");
                ++keyCounter;
            }
            if (keyCounter < dataWithKeys.changeIndices.length && count == dataWithKeys.changeIndices[keyCounter]) {
                System.out.println("timestamp " + count + " CHANGE ");
                ++keyCounter;
            }
            if (result.getAnomalyGrade() != 0.0) {
                int i;
                System.out.print("timestamp " + count + " RESULT value ");
                for (i = 0; i < baseDimensions; ++i) {
                    System.out.print(result.getCurrentInput()[i] + ", ");
                }
                System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
                if (result.isExpectedValuesPresent()) {
                    if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                        System.out.print(-result.getRelativeIndex() + " steps ago, instead of ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getPastValues()[i] + ", ");
                        }
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getPastValues()[i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getPastValues()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    } else {
                        System.out.print("expected ");
                        for (i = 0; i < baseDimensions; ++i) {
                            System.out.print(result.getExpectedValuesList()[0][i] + ", ");
                            if (result.getCurrentInput()[i] == result.getExpectedValuesList()[0][i]) continue;
                            System.out.print("( " + (result.getCurrentInput()[i] - result.getExpectedValuesList()[0][i]) + " ) ");
                        }
                    }
                }
                System.out.println();
            }
            ++count;
        }
    }
}

