/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestMapper;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.testutils.ShingledMultiDimDataWithKeys;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;

public class ThresholdedRCFJsonExample
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedRCFJsonExample().run();
    }

    @Override
    public String command() {
        return "json";
    }

    @Override
    public String description() {
        return "serialize a Thresholded Random Cut Forest as a JSON string";
    }

    @Override
    public void run() throws Exception {
        int baseDimension = 2;
        int shingleSize = 8;
        int numberOfTrees = 50;
        int sampleSize = 256;
        long seed = new Random().nextLong();
        System.out.println("seed :" + seed);
        Random rng = new Random(seed);
        int dimensions = baseDimension * shingleSize;
        ThresholdedRandomCutForest forest = ThresholdedRandomCutForest.builder().dimensions(dimensions).shingleSize(shingleSize).transformMethod(TransformMethod.NORMALIZE).numberOfTrees(numberOfTrees).sampleSize(sampleSize).build();
        int dataSize = 4 * sampleSize;
        int testSize = sampleSize;
        double[][] data = ShingledMultiDimDataWithKeys.getMultiDimData((int)(dataSize + shingleSize - 1), (int)50, (double)100.0, (double)5.0, (long)rng.nextLong(), (int)baseDimension, (double)5.0, (boolean)false).data;
        for (int i = 0; i < data.length - testSize; ++i) {
            forest.process(data[i], 0L);
        }
        ThresholdedRandomCutForestMapper mapper = new ThresholdedRandomCutForestMapper();
        ObjectMapper jsonMapper = new ObjectMapper();
        String json = jsonMapper.writeValueAsString((Object)mapper.toState(forest));
        System.out.printf("JSON size = %d bytes%n", json.getBytes().length);
        ThresholdedRandomCutForest forest2 = (ThresholdedRandomCutForest)mapper.toModel((Object)((ThresholdedRandomCutForestState)jsonMapper.readValue(json, ThresholdedRandomCutForestState.class)));
        for (int i = data.length; i < data.length; ++i) {
            AnomalyDescriptor result = forest.process(data[i], 0L);
            AnomalyDescriptor shadow = forest2.process(data[i], 0L);
            assert (Math.abs(result.getRCFScore() - shadow.getRCFScore()) < 1.0E-6);
        }
        System.out.println("Looks good!");
    }
}

