/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.summarization;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.testutils.ExampleDataSets;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import com.amazon.randomcutforest.util.Weighted;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DynamicSummarization
implements Example {
    public static void main(String[] args) throws Exception {
        new DynamicSummarization().run();
    }

    @Override
    public String command() {
        return "dynamic_summarization";
    }

    @Override
    public String description() {
        return "shows a potential use of dynamic clustering/summarization";
    }

    @Override
    public void run() throws Exception {
        int newDimensions = 2;
        long randomSeed = 123L;
        int dataSize = 1350;
        int numberOfBlades = 9;
        RandomCutForest newForest = RandomCutForest.builder().numberOfTrees(100).sampleSize(256).dimensions(newDimensions).randomSeed(randomSeed).timeDecay(0.00125).centerOfMassEnabled(true).build();
        String name = "dynamic_summarization_example";
        BufferedWriter file = new BufferedWriter(new FileWriter(name));
        double[][] data = this.getData(dataSize, 0, numberOfBlades);
        boolean printData = false;
        boolean printClusters = true;
        List oldSummary = null;
        int[] oldColors = null;
        int count = 0;
        int sum = 0;
        for (int degree = 0; degree < 360; ++degree) {
            for (double[] datum : data) {
                double[] vec = ExampleDataSets.rotateClockWise((double[])datum, (double)(Math.PI * -2 * (double)degree / 360.0));
                if (printData) {
                    file.append(vec[0] + " " + vec[1] + "\n");
                }
                newForest.update(vec);
            }
            if (printData) {
                file.append("\n");
                file.append("\n");
            }
            List summary = newForest.summarize(2 * numberOfBlades + 2, 0.05, 5, 0.8, Summarizer::L2distance, oldSummary);
            sum += summary.size();
            System.out.println(degree + " " + summary.size());
            if (summary.size() == numberOfBlades) {
                ++count;
            }
            int[] colors = this.align(summary, oldSummary, oldColors);
            for (int i = 0; i < summary.size(); ++i) {
                double weight = ((ICluster)summary.get(i)).getWeight();
                for (Weighted representative : ((ICluster)summary.get(i)).getRepresentatives()) {
                    double t = (double)representative.weight / weight;
                    if (!(t > 0.05) || !printClusters) continue;
                    file.append(((float[])representative.index)[0] + " " + ((float[])representative.index)[1] + " " + t + " " + colors[i] + "\n");
                }
            }
            if (summary.size() == numberOfBlades) {
                oldSummary = summary;
                oldColors = colors;
            }
            if (!printClusters) continue;
            file.append("\n");
            file.append("\n");
        }
        System.out.println("Exact detection :" + (double)Math.round((double)count / 3.6) * 0.01 + " fraction, average number of clusters " + (double)Math.round((double)sum / 3.6) * 0.01);
        file.close();
    }

    public double[][] getData(int dataSize, int seed, int fans) {
        Random prg = new Random(0L);
        NormalMixtureTestData generator = new NormalMixtureTestData(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        int newDimensions = 2;
        double[][] data = generator.generateTestData(dataSize, newDimensions, seed);
        for (int i = 0; i < dataSize; ++i) {
            int nextFan = prg.nextInt(fans);
            double[] dArray = data[i];
            dArray[1] = dArray[1] * (1.0 / (double)fans);
            double[] dArray2 = data[i];
            dArray2[0] = dArray2[0] * 2.0;
            double[] dArray3 = data[i];
            dArray3[0] = dArray3[0] + (5.0 + (double)(fans / 2));
            data[i] = ExampleDataSets.rotateClockWise((double[])data[i], (double)(Math.PI * 2 * (double)nextFan / (double)fans));
        }
        return data;
    }

    int[] align(List<ICluster<float[]>> current, List<ICluster<float[]>> previous, int[] oldColors) {
        int[] nearest = new int[current.size()];
        if (previous == null || previous.size() == 0) {
            for (int i = 0; i < current.size(); ++i) {
                nearest[i] = i;
            }
        } else {
            Arrays.fill(nearest, previous.size() + 1);
            for (int i = 0; i < current.size(); ++i) {
                double dist = previous.get(0).distance(current.get(i), Summarizer::L1distance);
                nearest[i] = oldColors[0];
                for (int j = 1; j < previous.size(); ++j) {
                    double t = previous.get(j).distance(current.get(i), Summarizer::L1distance);
                    if (!(t < dist)) continue;
                    dist = t;
                    nearest[i] = oldColors[j];
                }
            }
        }
        return nearest;
    }
}

