/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import java.util.Arrays;
import lombok.Generated;

public class AnomalyDescriptor
extends RCFComputeDescriptor {
    public static int NUMBER_OF_EXPECTED_VALUES = 1;
    double anomalyGrade;
    double dataConfidence;
    boolean startOfAnomaly;
    boolean inHighScoreRegion;
    double[] relevantAttribution;
    double timeAttribution;
    double[] pastValues;
    long pastTimeStamp;
    double[][] expectedValuesList;
    double[] likelihoodOfValues;
    double threshold;

    public AnomalyDescriptor(double[] input, long inputTimeStamp) {
        super(input, inputTimeStamp);
    }

    public AnomalyDescriptor(double[] input, long inputTimeStamp, ForestMode forestMode, TransformMethod transformMethod, ImputationMethod imputationMethod) {
        super(input, inputTimeStamp, forestMode, transformMethod, imputationMethod);
    }

    public void setPastValues(double[] values) {
        this.pastValues = this.copyIfNotnull(values);
    }

    public boolean isExpectedValuesPresent() {
        return this.expectedValuesList != null;
    }

    public void setRelevantAttribution(double[] values) {
        this.relevantAttribution = this.copyIfNotnull(values);
    }

    public void setExpectedValues(int position, double[] values, double likelihood) {
        CommonUtils.checkArgument((position < NUMBER_OF_EXPECTED_VALUES ? 1 : 0) != 0, (String)"Increase size of expected array");
        if (this.expectedValuesList == null) {
            this.expectedValuesList = new double[NUMBER_OF_EXPECTED_VALUES][];
        }
        if (this.likelihoodOfValues == null) {
            this.likelihoodOfValues = new double[NUMBER_OF_EXPECTED_VALUES];
        }
        this.expectedValuesList[position] = Arrays.copyOf(values, values.length);
        this.likelihoodOfValues[position] = likelihood;
    }

    public void setDataConfidence(double timeDecay, long valuesSeen, long outputAfter, double dataQuality) {
        long total = valuesSeen;
        double lambda = timeDecay;
        double totalExponent = (double)total * lambda;
        if (totalExponent == 0.0) {
            this.dataConfidence = 0.0;
        } else if (totalExponent >= 20.0) {
            this.dataConfidence = Math.min(1.0, dataQuality);
        } else {
            double eTotal = Math.exp(totalExponent);
            double confidence = dataQuality * (eTotal - Math.exp(lambda * (double)Math.min(total, outputAfter))) / (eTotal - 1.0);
            this.dataConfidence = Math.max(0.0, confidence);
        }
    }

    @Generated
    public double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    @Generated
    public double getDataConfidence() {
        return this.dataConfidence;
    }

    @Generated
    public boolean isStartOfAnomaly() {
        return this.startOfAnomaly;
    }

    @Generated
    public boolean isInHighScoreRegion() {
        return this.inHighScoreRegion;
    }

    @Generated
    public double[] getRelevantAttribution() {
        return this.relevantAttribution;
    }

    @Generated
    public double getTimeAttribution() {
        return this.timeAttribution;
    }

    @Generated
    public double[] getPastValues() {
        return this.pastValues;
    }

    @Generated
    public long getPastTimeStamp() {
        return this.pastTimeStamp;
    }

    @Generated
    public double[][] getExpectedValuesList() {
        return this.expectedValuesList;
    }

    @Generated
    public double[] getLikelihoodOfValues() {
        return this.likelihoodOfValues;
    }

    @Generated
    public double getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setAnomalyGrade(double anomalyGrade) {
        this.anomalyGrade = anomalyGrade;
    }

    @Generated
    public void setDataConfidence(double dataConfidence) {
        this.dataConfidence = dataConfidence;
    }

    @Generated
    public void setStartOfAnomaly(boolean startOfAnomaly) {
        this.startOfAnomaly = startOfAnomaly;
    }

    @Generated
    public void setInHighScoreRegion(boolean inHighScoreRegion) {
        this.inHighScoreRegion = inHighScoreRegion;
    }

    @Generated
    public void setTimeAttribution(double timeAttribution) {
        this.timeAttribution = timeAttribution;
    }

    @Generated
    public void setPastTimeStamp(long pastTimeStamp) {
        this.pastTimeStamp = pastTimeStamp;
    }

    @Generated
    public void setExpectedValuesList(double[][] expectedValuesList) {
        this.expectedValuesList = expectedValuesList;
    }

    @Generated
    public void setLikelihoodOfValues(double[] likelihoodOfValues) {
        this.likelihoodOfValues = likelihoodOfValues;
    }

    @Generated
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }
}

