/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;
import lombok.Generated;

public class ForecastDescriptor
extends AnomalyDescriptor {
    TimedRangeVector timedForecast;
    RangeVector observedErrorDistribution;
    DiVector errorRMSE;
    float[] errorMean;
    float[] calibration;

    public ForecastDescriptor(double[] input, long inputTimeStamp, int horizon) {
        super(input, inputTimeStamp);
        int forecastLength = input.length * horizon;
        this.timedForecast = new TimedRangeVector(forecastLength, horizon);
        this.observedErrorDistribution = new RangeVector(forecastLength);
        Arrays.fill(this.observedErrorDistribution.lower, -3.4028235E38f);
        Arrays.fill(this.observedErrorDistribution.upper, Float.MAX_VALUE);
        this.errorMean = new float[forecastLength];
        this.errorRMSE = new DiVector(forecastLength);
        this.calibration = new float[forecastLength];
    }

    public ForecastDescriptor(double[] input, long inputTimeStamp, ForestMode forestMode, TransformMethod transformMethod, ImputationMethod imputationMethod, int dimensions, int horizon) {
        super(input, inputTimeStamp, forestMode, transformMethod, imputationMethod);
        this.timedForecast = new TimedRangeVector(dimensions, horizon);
        this.observedErrorDistribution = new RangeVector(dimensions);
        Arrays.fill(this.observedErrorDistribution.lower, -3.4028235E38f);
        Arrays.fill(this.observedErrorDistribution.upper, Float.MAX_VALUE);
        this.errorMean = new float[dimensions];
        this.errorRMSE = new DiVector(dimensions);
    }

    void setObservedErrorDistribution(RangeVector base) {
        CommonUtils.checkArgument((base.values.length == this.observedErrorDistribution.values.length ? 1 : 0) != 0, (String)" incorrect length");
        System.arraycopy(base.values, 0, this.observedErrorDistribution.values, 0, base.values.length);
        System.arraycopy(base.upper, 0, this.observedErrorDistribution.upper, 0, base.upper.length);
        System.arraycopy(base.lower, 0, this.observedErrorDistribution.lower, 0, base.lower.length);
    }

    void setCalibration(float[] calibration) {
        System.arraycopy(calibration, 0, this.calibration, 0, calibration.length);
    }

    void setErrorMean(float[] errorMean) {
        System.arraycopy(errorMean, 0, this.errorMean, 0, errorMean.length);
    }

    void setErrorRMSE(DiVector errorRMSE) {
        CommonUtils.checkArgument((this.errorRMSE.getDimensions() == errorRMSE.getDimensions() ? 1 : 0) != 0, (String)" incorrect input");
        System.arraycopy(errorRMSE.high, 0, this.errorRMSE.high, 0, errorRMSE.high.length);
        System.arraycopy(errorRMSE.low, 0, this.errorRMSE.low, 0, errorRMSE.low.length);
    }

    @Generated
    public TimedRangeVector getTimedForecast() {
        return this.timedForecast;
    }

    @Generated
    public RangeVector getObservedErrorDistribution() {
        return this.observedErrorDistribution;
    }

    @Generated
    public DiVector getErrorRMSE() {
        return this.errorRMSE;
    }

    @Generated
    public float[] getErrorMean() {
        return this.errorMean;
    }

    @Generated
    public float[] getCalibration() {
        return this.calibration;
    }

    @Generated
    public void setTimedForecast(TimedRangeVector timedForecast) {
        this.timedForecast = timedForecast;
    }
}

