/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.util.Weighted;
import java.util.Arrays;

public class PredictorCorrector {
    private static double DEFAULT_DIFFERENTIAL_FACTOR = 0.3;
    public static int DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS = 5;
    double[] ignoreNearExpectedFromBelow;
    double[] ignoreNearExpectedFromAbove;
    protected int numberOfAttributors = DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS;
    protected double lastScore = 0.0;
    protected BasicThresholder thresholder;

    public PredictorCorrector(BasicThresholder thresholder, int baseDimension) {
        this.thresholder = thresholder;
        this.ignoreNearExpectedFromAbove = new double[baseDimension];
        this.ignoreNearExpectedFromBelow = new double[baseDimension];
    }

    public BasicThresholder getThresholder() {
        return this.thresholder;
    }

    protected int maxContribution(DiVector diVector, int baseDimension, int startIndex) {
        int i;
        double val = 0.0;
        int index = startIndex;
        int position = diVector.getDimensions() + startIndex * baseDimension;
        for (i = 0; i < baseDimension; ++i) {
            val += diVector.getHighLowSum(i + position);
        }
        for (i = position + baseDimension; i < diVector.getDimensions(); i += baseDimension) {
            double sum = 0.0;
            for (int j = 0; j < baseDimension; ++j) {
                sum += diVector.getHighLowSum(i + j);
            }
            if (!(sum > val)) continue;
            val = sum;
            index = (i - diVector.getDimensions()) / baseDimension;
        }
        return index;
    }

    protected double[] getExpectedPoint(DiVector diVector, int position, int baseDimension, double[] point, RandomCutForest forest) {
        int[] likelyMissingIndices;
        if (baseDimension == 1) {
            likelyMissingIndices = new int[]{position};
        } else {
            int pick;
            double sum = 0.0;
            double[] values = new double[baseDimension];
            for (int i = 0; i < baseDimension; ++i) {
                values[i] = diVector.getHighLowSum(i + position);
                sum += values[i];
            }
            Arrays.sort(values);
            if (values[baseDimension - pick] < 0.1 * sum) {
                return null;
            }
            for (pick = 1; pick < baseDimension && values[baseDimension - pick - 1] >= 0.1 * sum; ++pick) {
            }
            if (pick > DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS) {
                return null;
            }
            double cutoff = values[baseDimension - pick];
            likelyMissingIndices = new int[pick];
            int count = 0;
            for (int i = 0; i < baseDimension && count < pick; ++i) {
                if (!(diVector.getHighLowSum(i + position) >= cutoff) || count != 0 && !(diVector.getHighLowSum(i + position) > sum * 0.1)) continue;
                likelyMissingIndices[count++] = position + i;
            }
        }
        if ((double)likelyMissingIndices.length > 0.5 * (double)forest.getDimensions()) {
            return null;
        }
        return forest.imputeMissingValues(point, likelyMissingIndices.length, likelyMissingIndices);
    }

    protected boolean trigger(DiVector candidate, int gap, int baseDimension, DiVector ideal, TransformMethod method, IRCFComputeDescriptor lastAnomalyDescriptor) {
        DiVector lastAnomalyAttribution = lastAnomalyDescriptor.getAttribution();
        double lastAnomalyScore = lastAnomalyDescriptor.getRCFScore();
        if (lastAnomalyAttribution == null) {
            return true;
        }
        CommonUtils.checkArgument((lastAnomalyAttribution.getDimensions() == candidate.getDimensions() ? 1 : 0) != 0, (String)" error in DiVectors");
        int dimensions = candidate.getDimensions();
        int shingleSize = dimensions / baseDimension;
        int difference = baseDimension * gap;
        if (difference < dimensions) {
            if (ideal == null) {
                double remainder = 0.0;
                for (int i = dimensions - difference; i < dimensions; ++i) {
                    remainder += candidate.getHighLowSum(i);
                }
                return this.thresholder.getThresholdAndGrade((double)(remainder * (double)dimensions / (double)difference), (TransformMethod)method, (int)baseDimension, (int)shingleSize).weight > 0.0f;
            }
            double differentialRemainder = 0.0;
            for (int i = dimensions - difference; i < dimensions; ++i) {
                differentialRemainder += Math.abs(candidate.low[i] - ideal.low[i]) + Math.abs(candidate.high[i] - ideal.high[i]);
            }
            return differentialRemainder > DEFAULT_DIFFERENTIAL_FACTOR * lastAnomalyScore && this.thresholder.getThresholdAndGrade((double)(differentialRemainder * (double)dimensions / (double)difference), (TransformMethod)method, (int)baseDimension, (int)shingleSize).weight > 0.0f;
        }
        return true;
    }

    double[] applyBasicCorrector(double[] point, int gap, int shingleSize, int baseDimensions, IRCFComputeDescriptor lastAnomalyDescriptor) {
        CommonUtils.checkArgument((gap >= 0 && gap <= shingleSize ? 1 : 0) != 0, (String)"incorrect invocation");
        double[] correctedPoint = Arrays.copyOf(point, point.length);
        double[] lastExpectedPoint = lastAnomalyDescriptor.getExpectedRCFPoint();
        double[] lastAnomalyPoint = lastAnomalyDescriptor.getRCFPoint();
        int lastRelativeIndex = lastAnomalyDescriptor.getRelativeIndex();
        if (gap < shingleSize) {
            System.arraycopy(lastExpectedPoint, gap * baseDimensions, correctedPoint, 0, point.length - gap * baseDimensions);
        }
        if (lastRelativeIndex == 0) {
            TransformMethod transformMethod = lastAnomalyDescriptor.getTransformMethod();
            if (transformMethod == TransformMethod.DIFFERENCE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE) {
                for (int y = 0; y < baseDimensions; ++y) {
                    int n = point.length - gap * baseDimensions + y;
                    correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - baseDimensions + y] - lastExpectedPoint[point.length - baseDimensions + y]);
                }
            } else if (lastAnomalyDescriptor.getForestMode() == ForestMode.TIME_AUGMENTED) {
                int n = point.length - (gap - 1) * baseDimensions - 1;
                correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - 1] - lastExpectedPoint[point.length - 1]);
            }
        }
        return correctedPoint;
    }

    double calculatePathDeviation(double[] point, int startPosition, int index, int baseDimension, boolean differenced) {
        int position = startPosition;
        double variation = 0.0;
        while (position + index + baseDimension < point.length) {
            variation += differenced ? Math.abs(point[position + index]) : Math.abs(point[position + index] - point[position + baseDimension + index]);
            position += baseDimension;
        }
        return variation;
    }

    protected <P extends AnomalyDescriptor> boolean isSignificant(boolean significantScore, double[] point, double[] newPoint, int startPosition, P result) {
        CommonUtils.checkArgument((point.length == newPoint.length ? 1 : 0) != 0, (String)"incorrect invocation");
        int baseDimensions = result.getDimension() / result.getShingleSize();
        TransformMethod method = result.getTransformMethod();
        boolean differenced = method == TransformMethod.DIFFERENCE || method == TransformMethod.NORMALIZE_DIFFERENCE;
        double[] scale = result.getScale();
        double[] shift = result.getShift();
        if (scale == null || shift == null) {
            return true;
        }
        boolean answer = false;
        for (int y = 0; y < result.getInputLength() && !answer; ++y) {
            double pathGap;
            double observedGap = Math.abs(point[startPosition + y] - newPoint[startPosition + y]);
            if (!(observedGap > 0.1 * (pathGap = this.calculatePathDeviation(point, startPosition, y, baseDimensions, differenced)))) continue;
            double scaleFactor = scale == null ? 1.0 : scale[y];
            double delta = observedGap * scaleFactor;
            double shiftBase = shift == null ? 0.0 : shift[y];
            double shiftAmount = 0.0;
            if (shiftBase != 0.0) {
                double multiplier = method == TransformMethod.NORMALIZE ? 4.0 : 2.0;
                shiftAmount += multiplier * Preprocessor.DEFAULT_NORMALIZATION_PRECISION * Math.abs(shiftBase);
            }
            double a = Math.abs(scaleFactor * point[startPosition + y] + shiftBase);
            double b = Math.abs(scaleFactor * newPoint[startPosition + y] + shiftBase);
            if (scaleFactor != 1.0 || shiftBase != 0.0) {
                double multiplier = method == TransformMethod.NORMALIZE ? 2.0 : 1.0;
                shiftAmount += multiplier * Preprocessor.DEFAULT_NORMALIZATION_PRECISION * (scaleFactor + (a + b) / 2.0);
            }
            boolean bl = answer = significantScore || delta > shiftAmount + Preprocessor.DEFAULT_NORMALIZATION_PRECISION;
            if (!answer) continue;
            answer = a < b - this.ignoreNearExpectedFromBelow[y] || a > b + this.ignoreNearExpectedFromAbove[y];
        }
        return answer;
    }

    protected <P extends AnomalyDescriptor> P detect(P result, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point = result.getRCFPoint();
        if (point == null) {
            return result;
        }
        double score = 0.0;
        DiVector attribution = null;
        if (result.forestMode != ForestMode.DISTANCE) {
            score = forest.getAnomalyScore(point);
        } else {
            attribution = forest.getSimpleDensity((double[])point).distances;
            score = attribution.getHighLowSum();
        }
        result.setRCFScore(score);
        result.setRCFPoint(point);
        long internalTimeStamp = result.getInternalTimeStamp();
        if (score == 0.0) {
            return result;
        }
        int shingleSize = result.getDimension() == result.getInputLength() ? 1 : result.getShingleSize();
        int baseDimensions = result.getDimension() / shingleSize;
        int startPosition = (shingleSize - 1) * baseDimensions;
        double workingGrade = 0.0;
        double workingThreshold = 0.0;
        if (result.forestMode != ForestMode.DISTANCE) {
            Weighted<Double> thresholdAndGrade = this.thresholder.getThresholdAndGrade(score, result.transformMethod, baseDimensions, shingleSize);
            workingThreshold = (Double)thresholdAndGrade.index;
            workingGrade = thresholdAndGrade.weight;
        } else {
            workingThreshold = this.thresholder.getPrimaryThreshold();
            workingGrade = this.thresholder.getPrimaryGrade(score);
        }
        if (workingGrade <= 0.0) {
            result.setAnomalyGrade(0.0);
            result.setThreshold(workingThreshold);
            result.setInHighScoreRegion(false);
            this.thresholder.update(score, score, this.lastScore, result.transformMethod);
            if (shingleSize > 1) {
                this.lastScore = score;
            }
            return result;
        }
        int gap = (int)(internalTimeStamp - lastAnomalyDescriptor.getInternalTimeStamp());
        int difference = gap * baseDimensions;
        boolean reasonableForecast = result.isReasonableForecast();
        if (reasonableForecast && lastAnomalyDescriptor.getRCFPoint() != null && shingleSize > 1 && lastAnomalyDescriptor.getExpectedRCFPoint() != null && gap > 0 && gap <= shingleSize) {
            double[] correctedPoint = this.applyBasicCorrector(point, gap, shingleSize, baseDimensions, lastAnomalyDescriptor);
            double correctedScore = 0.0;
            if (result.forestMode != ForestMode.DISTANCE) {
                correctedScore = forest.getAnomalyScore(correctedPoint);
                workingGrade = this.thresholder.getThresholdAndGrade((double)correctedScore, (TransformMethod)result.transformMethod, (int)baseDimensions, (int)shingleSize).weight;
            } else {
                correctedScore = forest.getSimpleDensity((double[])correctedPoint).distances.getHighLowSum();
                workingGrade = this.thresholder.getPrimaryGrade(correctedScore);
            }
            if (workingGrade == 0.0) {
                result.setThreshold(workingThreshold);
                this.thresholder.update(score, correctedScore, this.lastScore, result.transformMethod);
                this.lastScore = correctedScore;
                result.setExpectedRCFPoint(correctedPoint);
                result.setAnomalyGrade(0.0);
                return result;
            }
        }
        if (result.forestMode != ForestMode.DISTANCE) {
            attribution = forest.getAnomalyAttribution(point);
        }
        double[] newPoint = null;
        double newScore = score;
        DiVector newAttribution = null;
        int relative = gap >= shingleSize ? -shingleSize : -gap;
        int index = shingleSize == 1 ? 0 : this.maxContribution(attribution, baseDimensions, relative) + 1;
        boolean significant = true;
        if (reasonableForecast && shingleSize > 1 && (newPoint = this.getExpectedPoint(attribution, startPosition = shingleSize * baseDimensions + (index - 1) * baseDimensions, baseDimensions, point, forest)) != null && result.getForestMode() != ForestMode.DISTANCE) {
            if (difference < point.length) {
                newAttribution = forest.getAnomalyAttribution(newPoint);
                newScore = newAttribution.getHighLowSum();
            } else {
                newScore = forest.getAnomalyScore(newPoint);
            }
            boolean significantScore = score > 1.5 || score > workingThreshold + 0.25 || score > newScore + 0.25 && gap > shingleSize;
            significant = this.isSignificant(significantScore, point, newPoint, startPosition, result);
        }
        if (!significant || difference <= point.length && !this.trigger(attribution, gap, baseDimensions, newAttribution, result.transformMethod, lastAnomalyDescriptor)) {
            result.setThreshold(score);
            this.thresholder.update(score, score, this.lastScore, result.transformMethod);
            this.lastScore = score;
            result.setAnomalyGrade(0.0);
            return result;
        }
        result.setExpectedRCFPoint(newPoint);
        result.setAnomalyGrade(workingGrade);
        result.setThreshold(workingThreshold);
        this.thresholder.update(score, newScore, this.lastScore, result.transformMethod);
        this.lastScore = score;
        result.setAttribution(attribution);
        result.setRelativeIndex(index);
        return result;
    }

    public void setZfactor(double factor) {
        this.thresholder.setZfactor(factor);
    }

    public void setLowerThreshold(double lower) {
        this.thresholder.setLowerThreshold(lower);
    }

    public void setScoreDifferencing(double persistence) {
        this.thresholder.setScoreDifferencing(persistence);
    }

    public void setInitialThreshold(double initial) {
        this.thresholder.setInitialThreshold(initial);
    }

    public void setIgnoreNearExpectedFromAbove(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.ignoreNearExpectedFromAbove = Arrays.copyOf(ignoreSimilarShift, ignoreSimilarShift.length);
        }
    }

    public void setIgnoreNearExpectedFromBelow(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.ignoreNearExpectedFromBelow = Arrays.copyOf(ignoreSimilarShift, ignoreSimilarShift.length);
        }
    }

    public double[] getIgnoreNearExpectedFromAbove() {
        return this.ignoreNearExpectedFromAbove;
    }

    public double[] getIgnoreNearExpectedFromBelow() {
        return this.ignoreNearExpectedFromBelow;
    }

    public void setNumberOfAttributors(int numberOfAttributors) {
        this.numberOfAttributors = numberOfAttributors;
    }

    public int getNumberOfAttributors() {
        return this.numberOfAttributors;
    }

    public double getLastScore() {
        return this.lastScore;
    }

    public void setLastScore(double score) {
        this.lastScore = score;
    }
}

