/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.ErrorHandler;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.calibration.Calibration;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;

public class RCFCaster
extends ThresholdedRandomCutForest {
    public static double DEFAULT_ERROR_PERCENTILE = 0.1;
    public static boolean USE_INTERPOLATION_IN_DISTRIBUTION = true;
    public static Calibration DEFAULT_CALIBRATION = Calibration.SIMPLE;
    public static BiFunction<Float, Float, Float> defaultError = (x, y) -> Float.valueOf(x.floatValue() - y.floatValue());
    public static BiFunction<Float, Float, Float> alternateError = (x, y) -> Float.valueOf(2.0f * (x.floatValue() - y.floatValue()) / (Math.abs(x.floatValue()) + Math.abs(y.floatValue())));
    protected int forecastHorizon;
    protected ErrorHandler errorHandler;
    protected int errorHorizon;
    protected Calibration calibrationMethod;

    public static Builder builder() {
        return new Builder();
    }

    public RCFCaster(Builder builder) {
        super(builder);
        CommonUtils.checkArgument((this.errorHorizon >= 2 * this.forecastHorizon ? 1 : 0) != 0, (String)"Error (used to compute interval precision of forecasts) horizon should be at least twice as large as forecast horizon");
        this.forecastHorizon = builder.forecastHorizon;
        this.errorHorizon = builder.errorHorizon;
        this.errorHandler = new ErrorHandler(builder);
        this.calibrationMethod = builder.calibrationMethod;
    }

    public RCFCaster(ForestMode forestMode, TransformMethod transformMethod, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor, int forecastHorizon, ErrorHandler errorHandler, int errorHorizon, Calibration calibrationMethod) {
        super(forestMode, transformMethod, forest, predictorCorrector, preprocessor, descriptor);
        this.forecastHorizon = forecastHorizon;
        this.errorHandler = errorHandler;
        this.errorHorizon = errorHorizon;
        this.calibrationMethod = calibrationMethod;
    }

    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForecastDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        ForecastDescriptor answer;
        CommonUtils.checkArgument((missingValues == null ? 1 : 0) != 0, (String)"on the fly imputation and error estimation should not mix");
        ForecastDescriptor initial = new ForecastDescriptor(inputPoint, timestamp, this.forecastHorizon);
        boolean cacheDisabled = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            double centralty = this.calibrationMethod == Calibration.NONE ? 1.0 - 2.0 * this.errorHandler.percentile : 1.0;
            TimedRangeVector timedForecast = this.extrapolate(this.forecastHorizon, true, centralty);
            answer = this.preprocessor.postProcess(this.predictorCorrector.detect(this.preprocessor.preProcess(initial, this.lastAnomalyDescriptor, this.forest), this.lastAnomalyDescriptor, this.forest), this.lastAnomalyDescriptor, this.forest);
            answer.setTimedForecast(timedForecast);
            if (answer.internalTimeStamp >= (long)(this.forest.getShingleSize() - 1 + this.forest.getOutputAfter())) {
                this.errorHandler.update(answer, this.calibrationMethod);
            }
        }
        finally {
            if (cacheDisabled) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        if (answer.getAnomalyGrade() > 0.0) {
            this.lastAnomalyDescriptor = answer.copyOf();
        }
        return answer;
    }

    public RangeVector computeErrorPercentile(double percentile, BiFunction<Float, Float, Float> error) {
        return this.computeErrorPercentile(percentile, this.errorHorizon, error);
    }

    public RangeVector computeErrorPercentile(double percentile, int newHorizon, BiFunction<Float, Float, Float> error) {
        return this.errorHandler.computeErrorPercentile(percentile, newHorizon, error);
    }

    @Generated
    public int getForecastHorizon() {
        return this.forecastHorizon;
    }

    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public int getErrorHorizon() {
        return this.errorHorizon;
    }

    @Generated
    public Calibration getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Generated
    public void setForecastHorizon(int forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    @Generated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public void setErrorHorizon(int errorHorizon) {
        this.errorHorizon = errorHorizon;
    }

    @Generated
    public void setCalibrationMethod(Calibration calibrationMethod) {
        this.calibrationMethod = calibrationMethod;
    }

    public static class Builder
    extends ThresholdedRandomCutForest.Builder<Builder> {
        int forecastHorizon;
        int errorHorizon;
        double percentile = DEFAULT_ERROR_PERCENTILE;
        protected Calibration calibrationMethod = DEFAULT_CALIBRATION;

        Builder() {
            this.transformMethod = TransformMethod.NORMALIZE;
        }

        public Builder forecastHorizon(int horizon) {
            this.forecastHorizon = horizon;
            return this;
        }

        public Builder errorHorizon(int errorHorizon) {
            this.errorHorizon = errorHorizon;
            return this;
        }

        public Builder percentile(double percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder calibration(Calibration calibrationMethod) {
            this.calibrationMethod = calibrationMethod;
            return this;
        }

        @Override
        public RCFCaster build() {
            CommonUtils.checkArgument((this.forecastHorizon > 0 ? 1 : 0) != 0, (String)"need non-negative horizon");
            CommonUtils.checkArgument((this.shingleSize > 0 ? 1 : 0) != 0, (String)"need shingle size > 1");
            CommonUtils.checkArgument((this.forestMode != ForestMode.STREAMING_IMPUTE ? 1 : 0) != 0, (String)"error estimation with on the fly imputation should not be abstracted, either estimate errors outside of this object or perform on the fly imputation outside this code");
            CommonUtils.checkArgument((this.forestMode != ForestMode.TIME_AUGMENTED ? 1 : 0) != 0, (String)"error estimation when time is used as a field in the forest should not be abstractedperform estimation outside this code");
            CommonUtils.checkArgument((!this.internalShinglingEnabled.isPresent() || (Boolean)this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)"internal shingling only");
            if (this.errorHorizon == 0) {
                this.errorHorizon = Math.max(this.sampleSize, 2 * this.forecastHorizon);
            }
            this.startNormalization = this.outputAfter.isPresent() ? Optional.of((Integer)this.outputAfter.get() + this.shingleSize - 1) : Optional.of((int)((double)this.sampleSize * 0.25) + this.shingleSize - 1);
            this.validate();
            return new RCFCaster(this);
        }
    }
}

