/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.RCFCaster;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.calibration.Calibration;
import com.amazon.randomcutforest.parkservices.returntypes.AnalysisDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SequentialAnalysis {
    public static List<AnomalyDescriptor> detectAnomalies(double[][] data, int shingleSize, int sampleSize, int numberOfTrees, double timeDecay, int outputAfter, TransformMethod transformMethod, double transformDecay, long seed) {
        CommonUtils.checkArgument((data != null ? 1 : 0) != 0, (String)"cannot be a null array");
        int inputDimension = data[0].length;
        int dimensions = inputDimension * shingleSize;
        double fraction = 1.0 * (double)outputAfter / (double)sampleSize;
        ThresholdedRandomCutForest forest = ((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)((ThresholdedRandomCutForest.Builder)ThresholdedRandomCutForest.builder().dimensions(dimensions)).randomSeed(seed)).numberOfTrees(numberOfTrees)).shingleSize(shingleSize)).sampleSize(sampleSize)).internalShinglingEnabled(true)).anomalyRate(0.01)).forestMode(ForestMode.STANDARD)).timeDecay(timeDecay)).transformMethod(transformMethod)).outputAfter(outputAfter)).transformDecay(transformDecay)).initialAcceptFraction(fraction)).build();
        ArrayList<AnomalyDescriptor> answer = new ArrayList<AnomalyDescriptor>();
        for (double[] point : data) {
            AnomalyDescriptor result = forest.process(point, 0L);
            if (!(result.getAnomalyGrade() > 0.0)) continue;
            answer.add(result);
        }
        return answer;
    }

    public static List<AnomalyDescriptor> detectAnomalies(double[][] data, int shingleSize, int sampleSize, double timeDecay, TransformMethod transformMethod) {
        return SequentialAnalysis.detectAnomalies(data, shingleSize, sampleSize, 50, timeDecay, sampleSize / 4, transformMethod, timeDecay, new Random().nextLong());
    }

    public static List<AnomalyDescriptor> detectAnomalies(double[][] data, int shingleSize, double timeDecay, TransformMethod transformMethod, double transformDecay) {
        return SequentialAnalysis.detectAnomalies(data, shingleSize, 256, 50, timeDecay, 64, transformMethod, transformDecay, new Random().nextLong());
    }

    public static AnalysisDescriptor forecastWithAnomalies(double[][] inputArray, int shingleSize, int sampleSize, double timeDecay, int outputAfter, TransformMethod transformMethod, double transformDecay, int forecastHorizon, int errorHorizon, double percentile, Calibration calibration, long seed) {
        CommonUtils.checkArgument((inputArray != null ? 1 : 0) != 0, (String)" input cannot be null");
        int inputDimension = inputArray[0].length;
        int dimensions = shingleSize * inputDimension;
        int numberOfTrees = 50;
        double fraction = 1.0 * (double)outputAfter / (double)sampleSize;
        RCFCaster caster = ((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)((RCFCaster.Builder)RCFCaster.builder().dimensions(dimensions)).randomSeed(seed)).numberOfTrees(numberOfTrees)).shingleSize(shingleSize)).sampleSize(sampleSize)).internalShinglingEnabled(true)).anomalyRate(0.01)).forestMode(ForestMode.STANDARD)).timeDecay(timeDecay)).transformMethod(transformMethod)).outputAfter(outputAfter)).calibration(calibration).initialAcceptFraction(fraction)).forecastHorizon(forecastHorizon).transformDecay(transformDecay)).errorHorizon(errorHorizon).percentile(percentile).build();
        ArrayList<AnomalyDescriptor> descriptors = new ArrayList<AnomalyDescriptor>();
        ForecastDescriptor last = null;
        for (double[] input : inputArray) {
            ForecastDescriptor descriptor = caster.process(input, 0L);
            if (descriptor.getAnomalyGrade() > 0.0) {
                descriptors.add(descriptor);
            }
            last = descriptor;
        }
        return new AnalysisDescriptor(descriptors, last);
    }

    public static AnalysisDescriptor forecastWithAnomalies(double[][] inputArray, int shingleSize, int sampleSize, double timeDecay, TransformMethod transformMethod, int forecastHorizon, int errorHorizon, long seed) {
        return SequentialAnalysis.forecastWithAnomalies(inputArray, shingleSize, sampleSize, timeDecay, sampleSize / 4, transformMethod, timeDecay, forecastHorizon, errorHorizon, 0.1, Calibration.SIMPLE, seed);
    }
}

