/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.WeightedTransformer;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import java.util.Arrays;

public class InitialSegmentPreprocessor
extends Preprocessor {
    public InitialSegmentPreprocessor(Preprocessor.Builder<?> builder) {
        super(builder);
        this.initialValues = new double[this.startNormalization][];
        this.initialTimeStamps = new long[this.startNormalization];
    }

    public AnomalyDescriptor preProcess(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        this.initialSetup(description, lastAnomalyDescriptor, forest);
        if (this.valuesSeen < this.startNormalization) {
            this.storeInitial(description.getCurrentInput(), description.getInputTimestamp());
            return description;
        }
        return super.preProcess(description, lastAnomalyDescriptor, forest);
    }

    public AnomalyDescriptor postProcess(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        AnomalyDescriptor answer = super.postProcess(description, lastAnomalyDescriptor, forest);
        if (this.valuesSeen == this.startNormalization) {
            this.dischargeInitial(forest);
        }
        return answer;
    }

    protected void storeInitial(double[] inputPoint, long timestamp) {
        this.initialTimeStamps[this.valuesSeen] = timestamp;
        this.initialValues[this.valuesSeen] = Arrays.copyOf(inputPoint, inputPoint.length);
        ++this.valuesSeen;
    }

    protected Deviation[] getDeviations() {
        if (InitialSegmentPreprocessor.requireInitialSegment(false, this.transformMethod)) {
            int j;
            int i;
            Deviation[] tempList = new Deviation[WeightedTransformer.NUMBER_OF_STATS * this.inputLength];
            for (int j2 = 0; j2 < WeightedTransformer.NUMBER_OF_STATS * this.inputLength; ++j2) {
                tempList[j2] = new Deviation(this.timeDecay);
            }
            for (i = 0; i < this.initialValues.length; ++i) {
                for (j = 0; j < this.inputLength; ++j) {
                    tempList[j].update(this.initialValues[i][j]);
                    double value = i == 0 ? 0.0 : this.initialValues[i][j] - this.initialValues[i - 1][j];
                    tempList[j + this.inputLength].update(value);
                }
            }
            for (i = 0; i < this.initialValues.length; ++i) {
                for (j = 0; j < this.inputLength; ++j) {
                    tempList[j + 2 * this.inputLength].update(this.initialValues[i][j] - tempList[j].getMean());
                }
            }
            return tempList;
        }
        return null;
    }

    protected void dischargeInitial(RandomCutForest forest) {
        Deviation tempTimeDeviation = new Deviation();
        for (int i = 0; i < this.initialTimeStamps.length - 1; ++i) {
            tempTimeDeviation.update(this.initialTimeStamps[i + 1] - this.initialTimeStamps[i]);
        }
        double timeFactor = tempTimeDeviation.getDeviation();
        Deviation[] deviations = this.getDeviations();
        for (int i = 0; i < this.valuesSeen; ++i) {
            double[] scaledInput = this.getScaledInput(this.initialValues[i], this.initialTimeStamps[i], deviations, timeFactor);
            this.updateState(this.initialValues[i], scaledInput, this.initialTimeStamps[i], this.previousTimeStamps[this.shingleSize - 1]);
            this.dataQuality[0].update(1.0);
            forest.update(scaledInput);
        }
        this.initialTimeStamps = null;
        this.initialValues = null;
    }
}

