/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.ImputePreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.InitialSegmentPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.DifferenceTransformer;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.ITransformer;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.NormalizedDifferenceTransformer;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.NormalizedTransformer;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.SubtractMATransformer;
import com.amazon.randomcutforest.parkservices.preprocessor.transform.WeightedTransformer;
import com.amazon.randomcutforest.parkservices.returntypes.TimedRangeVector;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class Preprocessor
implements IPreprocessor {
    public static double DEFAULT_NORMALIZATION_PRECISION = 0.001;
    public static int DEFAULT_START_NORMALIZATION = 10;
    public static int DEFAULT_STOP_NORMALIZATION = Integer.MAX_VALUE;
    public static int DEFAULT_CLIP_NORMALIZATION = 100;
    public static boolean DEFAULT_NORMALIZATION = false;
    public static boolean DEFAULT_DIFFERENCING = false;
    public static double DEFAULT_USE_IMPUTED_FRACTION = 0.5;
    public static int MINIMUM_OBSERVATIONS_FOR_EXPECTED = 100;
    public static int DEFAULT_TIME_STATES = 3;
    public static int DEFAULT_DATA_QUALITY_STATES = 1;
    protected Deviation[] timeStampDeviations;
    protected boolean normalizeTime;
    protected boolean augmentTime;
    protected double weightTime;
    protected double timeDecay;
    protected long[] previousTimeStamps;
    protected int internalTimeStamp = 0;
    protected double[][] initialValues;
    protected long[] initialTimeStamps;
    protected int startNormalization;
    protected Integer stopNormalization;
    protected int valuesSeen = 0;
    protected double[] defaultFill;
    protected double useImputedFraction = DEFAULT_USE_IMPUTED_FRACTION;
    protected int numberOfImputed;
    protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
    protected double clipFactor = DEFAULT_CLIP_NORMALIZATION;
    protected double[] lastShingledInput;
    protected double[] lastShingledPoint;
    protected TransformMethod transformMethod;
    protected int shingleSize;
    protected int dimension;
    protected int inputLength;
    protected ForestMode mode;
    protected Deviation[] dataQuality;
    protected ITransformer transformer;

    public Preprocessor(Builder<?> builder) {
        CommonUtils.checkArgument((builder.transformMethod != null ? 1 : 0) != 0, (String)"transform required");
        CommonUtils.checkArgument((builder.forestMode != null ? 1 : 0) != 0, (String)" forest mode is required");
        CommonUtils.checkArgument((builder.inputLength > 0 ? 1 : 0) != 0, (String)"incorrect input length");
        CommonUtils.checkArgument((builder.shingleSize > 0 ? 1 : 0) != 0, (String)"incorrect shingle size");
        CommonUtils.checkArgument((builder.dimensions > 0 ? 1 : 0) != 0, (String)"incorrect dimensions");
        CommonUtils.checkArgument((builder.shingleSize == 1 || builder.dimensions % builder.shingleSize == 0 ? 1 : 0) != 0, (String)" shingle size should divide the dimensions");
        CommonUtils.checkArgument((builder.forestMode == ForestMode.TIME_AUGMENTED || builder.inputLength == builder.dimensions || builder.inputLength * builder.shingleSize == builder.dimensions ? 1 : 0) != 0, (String)"incorrect input size");
        CommonUtils.checkArgument((builder.forestMode != ForestMode.TIME_AUGMENTED || (builder.inputLength + 1) * builder.shingleSize == builder.dimensions ? 1 : 0) != 0, (String)"incorrect input size");
        CommonUtils.checkArgument((builder.startNormalization <= builder.stopNormalization ? 1 : 0) != 0, (String)"incorrect normalization parameters");
        CommonUtils.checkArgument((builder.startNormalization > 0 || !builder.normalizeTime ? 1 : 0) != 0, (String)" start of normalization cannot be 0");
        CommonUtils.checkArgument((builder.startNormalization > 0 || builder.transformMethod != TransformMethod.NORMALIZE && builder.transformMethod != TransformMethod.NORMALIZE_DIFFERENCE ? 1 : 0) != 0, (String)" start of normalization cannot be 0 for these transformations");
        CommonUtils.checkArgument((builder.weights == null || builder.weights.length >= builder.inputLength ? 1 : 0) != 0, (String)" incorrect weights");
        this.inputLength = builder.inputLength;
        this.dimension = builder.dimensions;
        this.shingleSize = builder.shingleSize;
        this.mode = builder.forestMode;
        this.lastShingledPoint = new double[this.dimension];
        this.transformMethod = builder.transformMethod;
        this.startNormalization = builder.startNormalization;
        this.stopNormalization = builder.stopNormalization;
        this.normalizeTime = builder.normalizeTime;
        double[] weights = new double[this.inputLength];
        Arrays.fill(weights, 1.0);
        if (builder.weights != null) {
            if (builder.weights.length == this.inputLength) {
                System.arraycopy(builder.weights, 0, weights, 0, this.inputLength);
                this.weightTime = builder.weightTime;
            } else {
                System.arraycopy(builder.weights, 0, weights, 0, this.inputLength);
                this.weightTime = builder.weights[this.inputLength];
            }
        } else {
            this.weightTime = builder.weightTime;
        }
        this.previousTimeStamps = new long[this.shingleSize];
        this.lastShingledInput = this.inputLength == this.dimension ? new double[this.dimension] : new double[this.shingleSize * this.inputLength];
        this.timeDecay = builder.timeDecay;
        this.dataQuality = builder.dataQuality.orElse(new Deviation[]{new Deviation(this.timeDecay)});
        Deviation[] deviationList = new Deviation[WeightedTransformer.NUMBER_OF_STATS * this.inputLength];
        this.manageDeviations(deviationList, builder.deviations, this.timeDecay);
        this.timeStampDeviations = new Deviation[DEFAULT_TIME_STATES];
        this.manageDeviations(this.timeStampDeviations, builder.timeDeviations, this.timeDecay);
        if (this.transformMethod == TransformMethod.NONE) {
            for (int i = 0; i < this.inputLength; ++i) {
                CommonUtils.checkArgument((weights[i] == 1.0 ? 1 : 0) != 0, (String)"incorrect weights");
            }
            this.transformer = new WeightedTransformer(weights, deviationList);
        } else {
            this.transformer = this.transformMethod == TransformMethod.WEIGHTED ? new WeightedTransformer(weights, deviationList) : (this.transformMethod == TransformMethod.DIFFERENCE ? new DifferenceTransformer(weights, deviationList) : (this.transformMethod == TransformMethod.SUBTRACT_MA ? new SubtractMATransformer(weights, deviationList) : (this.transformMethod == TransformMethod.NORMALIZE ? new NormalizedTransformer(weights, deviationList) : new NormalizedDifferenceTransformer(weights, deviationList))));
        }
        if (this.mode == ForestMode.STREAMING_IMPUTE) {
            this.imputationMethod = builder.imputationMethod;
            this.normalizeTime = true;
            if (this.imputationMethod == ImputationMethod.FIXED_VALUES) {
                int baseDimension = builder.dimensions / builder.shingleSize;
                CommonUtils.checkArgument((builder.fillValues != null && builder.fillValues.length == baseDimension ? 1 : 0) != 0, (String)" the number of values should match the shingled input");
                this.defaultFill = Arrays.copyOf(builder.fillValues, builder.fillValues.length);
            }
            this.useImputedFraction = builder.useImputedFraction.orElse(0.5);
        }
    }

    void manageDeviations(Deviation[] deviationList, Optional<Deviation[]> original, double timeDecay) {
        int i;
        CommonUtils.checkArgument((deviationList.length % 3 == 0 ? 1 : 0) != 0, (String)" has to be a multiple of three");
        int usedDeviations = 0;
        if (original.isPresent()) {
            Deviation[] list = original.get();
            usedDeviations = Math.min(list.length, deviationList.length);
            for (int i2 = 0; i2 < usedDeviations; ++i2) {
                deviationList[i2] = list[i2].copy();
            }
        }
        for (i = usedDeviations; i < deviationList.length - deviationList.length / 3; ++i) {
            deviationList[i] = new Deviation(timeDecay);
        }
        for (i = usedDeviations = Math.max(usedDeviations, deviationList.length - deviationList.length / 3); i < deviationList.length; ++i) {
            deviationList[i] = new Deviation(0.1 * timeDecay);
        }
    }

    public static boolean requireInitialSegment(boolean normalizeTime, TransformMethod transformMethod) {
        return normalizeTime || transformMethod == TransformMethod.NORMALIZE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE;
    }

    <P extends AnomalyDescriptor> P initialSetup(P description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        description.setForestMode(this.mode);
        description.setTransformMethod(this.transformMethod);
        description.setImputationMethod(this.imputationMethod);
        description.setNumberOfTrees(forest.getNumberOfTrees());
        description.setTotalUpdates(forest.getTotalUpdates());
        description.setLastAnomalyInternalTimestamp(lastAnomalyDescriptor.getInternalTimeStamp());
        description.setLastExpectedRCFPoint(lastAnomalyDescriptor.getExpectedRCFPoint());
        description.setDataConfidence(forest.getTimeDecay(), this.valuesSeen, forest.getOutputAfter(), this.dataQuality[0].getMean());
        description.setShingleSize(this.shingleSize);
        description.setInputLength(this.inputLength);
        description.setDimension(this.dimension);
        long adjustedInternal = this.internalTimeStamp + (forest.isInternalShinglingEnabled() ? 0 : this.shingleSize - 1);
        int dataDimension = forest.isInternalShinglingEnabled() || this.mode == ForestMode.STREAMING_IMPUTE ? this.inputLength * this.shingleSize : this.inputLength;
        description.setReasonableForecast(adjustedInternal > (long)MINIMUM_OBSERVATIONS_FOR_EXPECTED && dataDimension >= 4);
        return description;
    }

    @Override
    public <P extends AnomalyDescriptor> P preProcess(P description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point;
        this.initialSetup(description, lastAnomalyDescriptor, forest);
        double[] inputPoint = description.getCurrentInput();
        long timestamp = description.getInputTimestamp();
        double[] scaledInput = this.getScaledInput(inputPoint, timestamp, null, 0.0);
        if (scaledInput == null) {
            return description;
        }
        if (forest.isInternalShinglingEnabled()) {
            point = CommonUtils.toDoubleArray((float[])forest.transformToShingledPoint(CommonUtils.toFloatArray((double[])scaledInput)));
        } else {
            int dimension = forest.getDimensions();
            if (scaledInput.length == dimension) {
                point = scaledInput;
            } else {
                point = new double[dimension];
                System.arraycopy(this.getLastShingledPoint(), scaledInput.length, point, 0, dimension - scaledInput.length);
                System.arraycopy(scaledInput, 0, point, dimension - scaledInput.length, scaledInput.length);
            }
        }
        description.setRCFPoint(point);
        description.setInternalTimeStamp(this.internalTimeStamp);
        description.setScale(this.transformer.getScale());
        double[] previous = inputPoint.length == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        description.setShift(this.transformer.getShift(previous));
        description.setDeviations(this.transformer.getSmoothedDeviations());
        description.setNumberOfNewImputes(0);
        return description;
    }

    @Override
    public <P extends AnomalyDescriptor> P postProcess(P result, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point = result.getRCFPoint();
        if (point == null) {
            return result;
        }
        if (result.getAnomalyGrade() > 0.0) {
            this.addRelevantAttribution(result);
        }
        double[] inputPoint = result.getCurrentInput();
        long timestamp = result.getInputTimestamp();
        this.updateState(inputPoint, point, timestamp, this.previousTimeStamps[this.shingleSize - 1]);
        ++this.valuesSeen;
        this.dataQuality[0].update(1.0);
        if (forest.isInternalShinglingEnabled()) {
            int length = this.inputLength + (this.mode == ForestMode.TIME_AUGMENTED ? 1 : 0);
            double[] scaledInput = new double[length];
            System.arraycopy(point, point.length - length, scaledInput, 0, length);
            forest.update(scaledInput);
        } else {
            forest.update(point);
        }
        return result;
    }

    protected void addRelevantAttribution(AnomalyDescriptor result) {
        int base = this.dimension / this.shingleSize;
        double[] reference = result.getCurrentInput();
        double[] point = result.getRCFPoint();
        double[] newPoint = result.getExpectedRCFPoint();
        int index = result.getRelativeIndex();
        if (newPoint != null) {
            if (index < 0) {
                reference = this.getShingledInput(this.shingleSize + index);
                result.setPastTimeStamp(this.getTimeStamp(this.shingleSize - 1 + index));
            }
            result.setPastValues(reference);
            if (this.mode == ForestMode.TIME_AUGMENTED) {
                int endPosition = (this.shingleSize - 1 + index + 1) * this.dimension / this.shingleSize;
                double timeGap = newPoint[endPosition - 1] - point[endPosition - 1];
                long expectedTimestamp = timeGap == 0.0 ? this.getTimeStamp(this.shingleSize - 1 + index) : this.inverseMapTime(timeGap, index);
                result.setExpectedTimeStamp(expectedTimestamp);
            }
            double[] values = this.getExpectedValue(index, reference, point, newPoint);
            result.setExpectedValues(0, values, 1.0);
        }
        int startPosition = (this.shingleSize - 1 + result.getRelativeIndex()) * base;
        DiVector attribution = result.getAttribution();
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            --base;
        }
        double[] flattenedAttribution = new double[base];
        for (int i = 0; i < base; ++i) {
            flattenedAttribution[i] = attribution.getHighLowSum(startPosition + i);
        }
        result.setRelevantAttribution(flattenedAttribution);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            result.setTimeAttribution(attribution.getHighLowSum(startPosition + base));
        }
    }

    protected long inverseMapTime(double gap, int relativePosition) {
        CommonUtils.checkArgument((this.shingleSize + relativePosition >= 0 ? 1 : 0) != 0, (String)" error");
        return this.inverseMapTimeValue(gap, this.previousTimeStamps[this.shingleSize - 1 + relativePosition]);
    }

    protected long inverseMapTimeValue(double gap, long timestamp) {
        double factor = this.weightTime;
        if (factor == 0.0) {
            return 0L;
        }
        if (this.normalizeTime) {
            return Math.round((double)timestamp + this.timeStampDeviations[0].getMean() + 2.0 * gap * this.timeStampDeviations[2].getMean() / factor);
        }
        return Math.round(gap / factor + (double)timestamp);
    }

    public double[] getShingledInput(int index) {
        int base = this.lastShingledInput.length / this.shingleSize;
        double[] values = new double[base];
        System.arraycopy(this.lastShingledInput, index * base, values, 0, base);
        return values;
    }

    protected double[] getExpectedValue(int relativeBlockIndex, double[] reference, double[] point, double[] newPoint) {
        int base = this.dimension / this.shingleSize;
        int startPosition = (this.shingleSize - 1 + relativeBlockIndex) * base;
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            --base;
        }
        double[] values = this.invert(base, startPosition, relativeBlockIndex, newPoint);
        for (int i = 0; i < base; ++i) {
            double currentValue = reference.length == base ? reference[i] : reference[startPosition + i];
            values[i] = point[startPosition + i] == newPoint[startPosition + i] ? currentValue : values[i];
        }
        return values;
    }

    protected double[] invert(int base, int startPosition, int relativeBlockIndex, double[] newPoint) {
        double[] values = new double[base];
        System.arraycopy(newPoint, startPosition, values, 0, base);
        return this.transformer.invert(values, this.getShingledInput(this.shingleSize - 1 + relativeBlockIndex));
    }

    @Override
    public TimedRangeVector invertForecastRange(RangeVector ranges, IRCFComputeDescriptor lastAnomalyDescriptor) {
        TimedRangeVector timedRangeVector;
        int baseDimension = this.inputLength + (this.mode == ForestMode.TIME_AUGMENTED ? 1 : 0);
        CommonUtils.checkArgument((ranges.values.length % baseDimension == 0 ? 1 : 0) != 0, (String)" incorrect length of ranges");
        int horizon = ranges.values.length / baseDimension;
        int gap = (int)((long)this.internalTimeStamp - lastAnomalyDescriptor.getInternalTimeStamp());
        long localTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
        if (this.mode != ForestMode.TIME_AUGMENTED) {
            timedRangeVector = new TimedRangeVector(ranges, horizon);
            if (this.mode != ForestMode.STREAMING_IMPUTE) {
                double timeGap = this.normalizeTime ? 0.0 : this.timeStampDeviations[0].getMean();
                double timeBound = this.normalizeTime ? 2.5 : 2.5 * this.timeStampDeviations[2].getMean();
                for (int i = 0; i < horizon; ++i) {
                    timedRangeVector.timeStamps[i] = this.inverseMapTimeValue(timeGap, localTimeStamp);
                    timedRangeVector.upperTimeStamps[i] = Math.max(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(timeGap + timeBound, localTimeStamp));
                    timedRangeVector.lowerTimeStamps[i] = Math.min(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(0.0, timeGap - timeBound), localTimeStamp));
                    localTimeStamp = timedRangeVector.upperTimeStamps[i];
                }
            }
        } else {
            timedRangeVector = new TimedRangeVector(this.inputLength * horizon, horizon);
            if (gap <= this.shingleSize && lastAnomalyDescriptor.getExpectedRCFPoint() != null && gap == 1) {
                localTimeStamp = lastAnomalyDescriptor.getExpectedTimeStamp();
            }
            for (int i = 0; i < horizon; ++i) {
                for (int j = 0; j < this.inputLength; ++j) {
                    timedRangeVector.rangeVector.values[i * this.inputLength + j] = ranges.values[i * baseDimension + j];
                    timedRangeVector.rangeVector.upper[i * this.inputLength + j] = ranges.upper[i * baseDimension + j];
                    timedRangeVector.rangeVector.lower[i * this.inputLength + j] = ranges.lower[i * baseDimension + j];
                }
                timedRangeVector.timeStamps[i] = this.inverseMapTimeValue(Math.max(ranges.values[i * baseDimension + this.inputLength], 0.0f), localTimeStamp);
                timedRangeVector.upperTimeStamps[i] = Math.max(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(ranges.upper[i * baseDimension + this.inputLength], 0.0f), localTimeStamp));
                timedRangeVector.lowerTimeStamps[i] = Math.min(timedRangeVector.timeStamps[i], this.inverseMapTimeValue(Math.max(ranges.lower[i * baseDimension + this.inputLength], 0.0f), localTimeStamp));
                localTimeStamp = timedRangeVector.upperTimeStamps[i];
            }
        }
        this.transformer.invertForecastRange(timedRangeVector.rangeVector, this.inputLength, this.getShingledInput(this.shingleSize - 1));
        return timedRangeVector;
    }

    protected double[] getScaledInput(double[] input, long timestamp, Deviation[] defaults, double defaultTimeFactor) {
        double[] previous = input.length == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        double[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, input, previous, defaults, this.clipFactor);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            scaledInput = this.augmentTime(scaledInput, timestamp, defaultTimeFactor);
        }
        return scaledInput;
    }

    protected void updateShingle(double[] inputPoint, double[] scaledPoint) {
        if (inputPoint.length == this.lastShingledInput.length) {
            this.lastShingledInput = Arrays.copyOf(inputPoint, inputPoint.length);
        } else {
            this.shiftLeft(this.lastShingledInput, inputPoint.length);
            this.copyAtEnd(this.lastShingledInput, inputPoint);
        }
        if (scaledPoint.length == this.lastShingledPoint.length) {
            this.lastShingledPoint = Arrays.copyOf(scaledPoint, scaledPoint.length);
        } else {
            this.shiftLeft(this.lastShingledPoint, scaledPoint.length);
            this.copyAtEnd(this.lastShingledPoint, scaledPoint);
        }
    }

    protected void updateTimestamps(long timestamp) {
        for (int i = 0; i < this.shingleSize - 1; ++i) {
            this.previousTimeStamps[i] = this.previousTimeStamps[i + 1];
        }
        this.previousTimeStamps[this.shingleSize - 1] = timestamp;
        ++this.internalTimeStamp;
    }

    protected void updateState(double[] inputPoint, double[] scaledInput, long timestamp, long previous) {
        if (this.timeStampDeviations != null) {
            double value = timestamp - previous;
            this.timeStampDeviations[0].update(value);
            this.timeStampDeviations[1].update(Math.log(Math.max(1.0, 1.0 + value)));
            this.timeStampDeviations[2].update(this.timeStampDeviations[0].getDeviation());
        }
        this.updateTimestamps(timestamp);
        double[] previousInput = this.inputLength == this.lastShingledInput.length ? this.lastShingledInput : this.getShingledInput(this.shingleSize - 1);
        this.transformer.updateDeviation(inputPoint, previousInput);
        this.updateShingle(inputPoint, scaledInput);
    }

    protected void copyAtEnd(double[] array, double[] small) {
        CommonUtils.checkArgument((array.length > small.length ? 1 : 0) != 0, (String)" incorrect operation ");
        System.arraycopy(small, 0, array, array.length - small.length, small.length);
    }

    protected double[] copyIfNotnull(double[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    protected void shiftLeft(double[] array, int baseDimension) {
        for (int i = 0; i < array.length - baseDimension; ++i) {
            array[i] = array[i + baseDimension];
        }
    }

    protected double normalize(double value, Deviation[] deviation, double factor) {
        double currentFactor;
        double d = currentFactor = factor != 0.0 ? factor : Math.abs(deviation[2].getMean());
        if (value - deviation[0].getMean() >= 2.0 * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return this.clipFactor;
        }
        if (value - deviation[0].getMean() < -2.0 * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return -this.clipFactor;
        }
        return (value - deviation[0].getMean()) / (2.0 * (currentFactor + DEFAULT_NORMALIZATION_PRECISION));
    }

    protected double[] augmentTime(double[] normalized, long timestamp, double timeFactor) {
        double[] scaledInput = new double[normalized.length + 1];
        System.arraycopy(normalized, 0, scaledInput, 0, normalized.length);
        if (this.valuesSeen <= 1) {
            scaledInput[normalized.length] = 0.0;
        } else {
            double timeShift = timestamp - this.previousTimeStamps[this.shingleSize - 1];
            scaledInput[normalized.length] = this.weightTime * (this.normalizeTime ? this.normalize(timeShift, this.timeStampDeviations, timeFactor) : timeShift);
        }
        return scaledInput;
    }

    public long[] getInitialTimeStamps() {
        return this.initialTimeStamps == null ? null : Arrays.copyOf(this.initialTimeStamps, this.initialTimeStamps.length);
    }

    public void setInitialTimeStamps(long[] values) {
        this.initialTimeStamps = values == null ? null : Arrays.copyOf(values, values.length);
    }

    public double[][] getInitialValues() {
        if (this.initialValues == null) {
            return null;
        }
        double[][] result = new double[this.initialValues.length][];
        for (int i = 0; i < this.initialValues.length; ++i) {
            result[i] = this.copyIfNotnull(this.initialValues[i]);
        }
        return result;
    }

    public void setInitialValues(double[][] values) {
        if (values == null) {
            this.initialValues = null;
        } else {
            this.initialValues = new double[values.length][];
            for (int i = 0; i < values.length; ++i) {
                this.initialValues[i] = this.copyIfNotnull(values[i]);
            }
        }
    }

    public double[] getLastShingledInput() {
        return this.copyIfNotnull(this.lastShingledInput);
    }

    public void setLastShingledInput(double[] point) {
        this.lastShingledInput = this.copyIfNotnull(point);
    }

    public void setPreviousTimeStamps(long[] values) {
        if (values == null) {
            this.numberOfImputed = this.shingleSize;
            this.previousTimeStamps = null;
        } else {
            CommonUtils.checkArgument((values.length == this.shingleSize ? 1 : 0) != 0, (String)" incorrect length ");
            this.previousTimeStamps = Arrays.copyOf(values, values.length);
            this.numberOfImputed = 0;
            for (int i = 0; i < this.previousTimeStamps.length - 1; ++i) {
                if (this.previousTimeStamps[i] != this.previousTimeStamps[i + 1]) continue;
                ++this.numberOfImputed;
            }
        }
    }

    public Deviation[] getTimeStampDeviations() {
        return this.timeStampDeviations;
    }

    public long[] getPreviousTimeStamps() {
        return this.previousTimeStamps == null ? null : Arrays.copyOf(this.previousTimeStamps, this.previousTimeStamps.length);
    }

    public Deviation[] getDeviationList() {
        return this.transformer.getDeviations();
    }

    public double[] getWeights() {
        double[] basic = this.transformer.getWeights();
        double[] answer = new double[this.inputLength + 1];
        Arrays.fill(answer, 1.0);
        if (basic != null) {
            CommonUtils.checkArgument((basic.length == this.inputLength ? 1 : 0) != 0, (String)" incorrect length returned");
            System.arraycopy(basic, 0, answer, 0, this.inputLength);
        }
        answer[this.inputLength] = this.weightTime;
        return answer;
    }

    public void setWeights(double[] values) {
        CommonUtils.checkArgument((values.length == this.inputLength ? 1 : 0) != 0, (String)"incorrect length");
        this.transformer.setWeights(values);
    }

    public void setWeightTime(double weightTime) {
        this.weightTime = weightTime;
    }

    public double[] getDefaultFill() {
        return this.copyIfNotnull(this.defaultFill);
    }

    public void setDefaultFill(double[] values) {
        this.defaultFill = this.copyIfNotnull(values);
    }

    public long getTimeStamp(int index) {
        return this.previousTimeStamps[index];
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public boolean isNormalizeTime() {
        return this.normalizeTime;
    }

    @Generated
    public boolean isAugmentTime() {
        return this.augmentTime;
    }

    @Generated
    public double getWeightTime() {
        return this.weightTime;
    }

    @Generated
    public double getTimeDecay() {
        return this.timeDecay;
    }

    @Override
    @Generated
    public int getInternalTimeStamp() {
        return this.internalTimeStamp;
    }

    @Generated
    public int getStartNormalization() {
        return this.startNormalization;
    }

    @Generated
    public Integer getStopNormalization() {
        return this.stopNormalization;
    }

    @Generated
    public int getValuesSeen() {
        return this.valuesSeen;
    }

    @Generated
    public double getUseImputedFraction() {
        return this.useImputedFraction;
    }

    @Generated
    public int getNumberOfImputed() {
        return this.numberOfImputed;
    }

    @Generated
    public ImputationMethod getImputationMethod() {
        return this.imputationMethod;
    }

    @Generated
    public double getClipFactor() {
        return this.clipFactor;
    }

    @Override
    @Generated
    public double[] getLastShingledPoint() {
        return this.lastShingledPoint;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Override
    @Generated
    public int getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Override
    @Generated
    public int getInputLength() {
        return this.inputLength;
    }

    @Generated
    public ForestMode getMode() {
        return this.mode;
    }

    @Generated
    public Deviation[] getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public ITransformer getTransformer() {
        return this.transformer;
    }

    @Generated
    public void setTimeStampDeviations(Deviation[] timeStampDeviations) {
        this.timeStampDeviations = timeStampDeviations;
    }

    @Generated
    public void setNormalizeTime(boolean normalizeTime) {
        this.normalizeTime = normalizeTime;
    }

    @Generated
    public void setAugmentTime(boolean augmentTime) {
        this.augmentTime = augmentTime;
    }

    @Generated
    public void setTimeDecay(double timeDecay) {
        this.timeDecay = timeDecay;
    }

    @Generated
    public void setInternalTimeStamp(int internalTimeStamp) {
        this.internalTimeStamp = internalTimeStamp;
    }

    @Generated
    public void setStartNormalization(int startNormalization) {
        this.startNormalization = startNormalization;
    }

    @Generated
    public void setStopNormalization(Integer stopNormalization) {
        this.stopNormalization = stopNormalization;
    }

    @Generated
    public void setValuesSeen(int valuesSeen) {
        this.valuesSeen = valuesSeen;
    }

    @Generated
    public void setUseImputedFraction(double useImputedFraction) {
        this.useImputedFraction = useImputedFraction;
    }

    @Generated
    public void setNumberOfImputed(int numberOfImputed) {
        this.numberOfImputed = numberOfImputed;
    }

    @Generated
    public void setImputationMethod(ImputationMethod imputationMethod) {
        this.imputationMethod = imputationMethod;
    }

    @Generated
    public void setClipFactor(double clipFactor) {
        this.clipFactor = clipFactor;
    }

    @Generated
    public void setLastShingledPoint(double[] lastShingledPoint) {
        this.lastShingledPoint = lastShingledPoint;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    @Generated
    public void setMode(ForestMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setDataQuality(Deviation[] dataQuality) {
        this.dataQuality = dataQuality;
    }

    @Generated
    public void setTransformer(ITransformer transformer) {
        this.transformer = transformer;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int startNormalization = DEFAULT_START_NORMALIZATION;
        protected Integer stopNormalization = DEFAULT_STOP_NORMALIZATION;
        protected double timeDecay;
        protected Optional<Long> randomSeed = Optional.empty();
        protected int shingleSize = 1;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected int inputLength;
        protected boolean normalizeTime = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected double weightTime = 1.0;
        protected ThresholdedRandomCutForest thresholdedRandomCutForest = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected Optional<Deviation[]> deviations = Optional.empty();
        protected Optional<Deviation[]> timeDeviations = Optional.empty();
        protected Optional<Deviation[]> dataQuality = Optional.empty();

        public Preprocessor build() {
            if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                return new ImputePreprocessor(this);
            }
            if (Preprocessor.requireInitialSegment(this.normalizeTime, this.transformMethod)) {
                return new InitialSegmentPreprocessor(this);
            }
            return new Preprocessor(this);
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T inputLength(int inputLength) {
            this.inputLength = inputLength;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = startNormalization;
            return (T)this;
        }

        public T stopNormalization(Integer stopNormalization) {
            this.stopNormalization = stopNormalization;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = timeDecay;
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = value;
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T deviations(Deviation[] deviations) {
            this.deviations = Optional.ofNullable(deviations);
            return (T)this;
        }

        public T dataQuality(Deviation[] dataQuality) {
            this.dataQuality = Optional.ofNullable(dataQuality);
            return (T)this;
        }

        public T timeDeviations(Deviation[] timeDeviations) {
            this.timeDeviations = Optional.ofNullable(timeDeviations);
            return (T)this;
        }
    }
}

