/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor.transform;

import com.amazon.randomcutforest.parkservices.preprocessor.transform.NormalizedTransformer;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;

public class NormalizedDifferenceTransformer
extends NormalizedTransformer {
    public NormalizedDifferenceTransformer(double[] weights, Deviation[] deviation) {
        super(weights, deviation);
    }

    @Override
    public double[] invert(double[] values, double[] previousInput) {
        double[] output = super.invert(values, previousInput);
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            output[n] = output[n] + previousInput[i];
        }
        return output;
    }

    @Override
    public void invertForecastRange(RangeVector ranges, int baseDimension, double[] previousInput) {
        int inputLength = this.weights.length;
        int horizon = ranges.values.length / baseDimension;
        double[] last = Arrays.copyOf(previousInput, previousInput.length);
        for (int i = 0; i < horizon; ++i) {
            for (int j = 0; j < inputLength; ++j) {
                double weight = this.weights[j] == 0.0 ? 0.0 : this.getScale(j, this.deviations) / this.weights[j];
                ranges.scale(i * baseDimension + j, (float)weight);
                double shift = last[j] + this.getShift(j, this.deviations);
                ranges.shift(i * baseDimension + j, (float)shift);
                last[j] = ranges.values[i * baseDimension + j];
            }
        }
    }

    @Override
    public double[] transformValues(int internalTimeStamp, double[] inputPoint, double[] previousInput, Deviation[] initials, double clipFactor) {
        double[] input = new double[inputPoint.length];
        for (int i = 0; i < input.length; ++i) {
            input[i] = internalTimeStamp == 0 ? 0.0 : inputPoint[i] - previousInput[i];
        }
        return super.transformValues(internalTimeStamp, input, null, initials, clipFactor);
    }

    @Override
    public double[] getShift(double[] previous) {
        double[] answer = new double[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            answer[i] = this.getShift(i, this.deviations) + previous[i];
        }
        return answer;
    }

    @Override
    protected double getShift(int i, Deviation[] devs) {
        return devs[i + this.weights.length].getMean();
    }

    @Override
    protected double getScale(int i, Deviation[] devs) {
        return devs[i + this.weights.length].getDeviation() + 1.0;
    }
}

