/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.returntypes.RangeVector;
import java.util.Arrays;

public class TimedRangeVector {
    public final RangeVector rangeVector;
    public final long[] timeStamps;
    public final long[] upperTimeStamps;
    public final long[] lowerTimeStamps;

    public TimedRangeVector(int dimensions, int horizon) {
        CommonUtils.checkArgument((dimensions > 0 ? 1 : 0) != 0, (String)"dimensions must be greater than 0");
        CommonUtils.checkArgument((horizon > 0 ? 1 : 0) != 0, (String)"horizon must be greater than 0");
        CommonUtils.checkArgument((dimensions % horizon == 0 ? 1 : 0) != 0, (String)"horizon should divide dimensions");
        this.rangeVector = new RangeVector(dimensions);
        this.timeStamps = new long[horizon];
        this.upperTimeStamps = new long[horizon];
        this.lowerTimeStamps = new long[horizon];
    }

    public TimedRangeVector(RangeVector rangeVector, long[] timestamps, long[] upperTimeStamps, long[] lowerTimeStamps) {
        CommonUtils.checkArgument((rangeVector.values.length % timestamps.length == 0 ? 1 : 0) != 0, (String)" dimensions must be be divisible by horizon");
        CommonUtils.checkArgument((timestamps.length == upperTimeStamps.length && upperTimeStamps.length == lowerTimeStamps.length ? 1 : 0) != 0, (String)"horizon must be equal");
        this.rangeVector = new RangeVector(rangeVector);
        this.timeStamps = Arrays.copyOf(timestamps, timestamps.length);
        this.lowerTimeStamps = Arrays.copyOf(lowerTimeStamps, lowerTimeStamps.length);
        this.upperTimeStamps = Arrays.copyOf(upperTimeStamps, upperTimeStamps.length);
    }

    public TimedRangeVector(TimedRangeVector base) {
        this.rangeVector = new RangeVector(base.rangeVector);
        this.timeStamps = Arrays.copyOf(base.timeStamps, base.timeStamps.length);
        this.lowerTimeStamps = Arrays.copyOf(base.lowerTimeStamps, base.lowerTimeStamps.length);
        this.upperTimeStamps = Arrays.copyOf(base.upperTimeStamps, base.upperTimeStamps.length);
    }

    public TimedRangeVector(RangeVector base, int horizon) {
        CommonUtils.checkArgument((base.values.length % horizon == 0 ? 1 : 0) != 0, (String)"incorrect lengths");
        this.rangeVector = new RangeVector(base);
        this.timeStamps = new long[horizon];
        this.upperTimeStamps = new long[horizon];
        this.lowerTimeStamps = new long[horizon];
    }

    public void shiftTime(int i, long shift) {
        CommonUtils.checkArgument((i >= 0 && i < this.timeStamps.length ? 1 : 0) != 0, (String)"incorrect index");
        int n = i;
        this.timeStamps[n] = this.timeStamps[n] + shift;
        this.upperTimeStamps[i] = Math.max(this.timeStamps[i], this.upperTimeStamps[i] + shift);
        this.lowerTimeStamps[i] = Math.min(this.timeStamps[i], this.lowerTimeStamps[i] + shift);
    }

    public void scaleTime(int i, double weight) {
        CommonUtils.checkArgument((i >= 0 && i < this.timeStamps.length ? 1 : 0) != 0, (String)"incorrect index");
        CommonUtils.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)" negative weight not permitted");
        this.timeStamps[i] = (long)((double)this.timeStamps[i] * weight);
        this.upperTimeStamps[i] = Math.max((long)((double)this.upperTimeStamps[i] * weight), this.timeStamps[i]);
        this.lowerTimeStamps[i] = Math.min((long)((double)this.lowerTimeStamps[i] * weight), this.timeStamps[i]);
    }
}

