/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.ErrorHandler;
import com.amazon.randomcutforest.parkservices.state.ErrorHandlerState;
import com.amazon.randomcutforest.returntypes.RangeVector;
import com.amazon.randomcutforest.state.IStateMapper;
import java.util.Locale;

public class ErrorHandlerMapper
implements IStateMapper<ErrorHandler, ErrorHandlerState> {
    public ErrorHandlerState toState(ErrorHandler model) {
        int i;
        ErrorHandlerState errorHandlerState = new ErrorHandlerState();
        errorHandlerState.setSequenceIndex(model.getSequenceIndex());
        errorHandlerState.setPercentile(model.getPercentile());
        errorHandlerState.setForecastHorizon(model.getForecastHorizon());
        errorHandlerState.setErrorHorizon(model.getErrorHorizon());
        RangeVector[] pastForecasts = model.getPastForecasts();
        float[][] actuals = model.getActuals();
        int arrayLength = pastForecasts.length;
        CommonUtils.checkArgument((pastForecasts != null ? 1 : 0) != 0, (String)"pastForecasts cannot be null");
        CommonUtils.checkArgument((actuals != null ? 1 : 0) != 0, (String)"actuals cannot be null");
        CommonUtils.checkArgument((arrayLength == actuals.length ? 1 : 0) != 0, (String)String.format(Locale.ROOT, "actuals array length %d and pastForecasts array length %d is not equal", actuals.length, arrayLength));
        int forecastHorizon = model.getForecastHorizon();
        float[] pastForecastsFlattened = null;
        int inputLength = 0;
        if (pastForecasts.length == 0 || pastForecasts[0].values == null || pastForecasts[0].values.length == 0) {
            pastForecastsFlattened = new float[]{};
        } else {
            int pastForecastsLength = pastForecasts[0].values.length;
            inputLength = pastForecastsLength / forecastHorizon;
            pastForecastsFlattened = new float[arrayLength * 3 * forecastHorizon * inputLength];
            for (i = 0; i < arrayLength; ++i) {
                System.arraycopy(pastForecasts[i].values, 0, pastForecastsFlattened, 3 * i * pastForecastsLength, pastForecastsLength);
                System.arraycopy(pastForecasts[i].upper, 0, pastForecastsFlattened, (3 * i + 1) * pastForecastsLength, pastForecastsLength);
                System.arraycopy(pastForecasts[i].lower, 0, pastForecastsFlattened, (3 * i + 2) * pastForecastsLength, pastForecastsLength);
            }
        }
        errorHandlerState.setInputLength(inputLength);
        errorHandlerState.setPastForecastsFlattened(pastForecastsFlattened);
        float[] actualsFlattened = null;
        if (actuals.length == 0 || actuals[0].length == 0) {
            actualsFlattened = new float[]{};
        } else {
            actualsFlattened = new float[arrayLength * inputLength];
            for (i = 0; i < arrayLength; ++i) {
                System.arraycopy(actuals[i], 0, actualsFlattened, i * inputLength, inputLength);
            }
        }
        errorHandlerState.setActualsFlattened(actualsFlattened);
        return errorHandlerState;
    }

    public ErrorHandler toModel(ErrorHandlerState state, long seed) {
        return new ErrorHandler(state.getErrorHorizon(), state.getForecastHorizon(), state.getSequenceIndex(), state.getPercentile(), state.getInputLength(), state.getActualsFlattened(), state.getPastForecastsFlattened(), null);
    }
}

