/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.threshold;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.util.Weighted;
import java.util.List;

public class BasicThresholder {
    public static double DEFAULT_SCORE_DIFFERENCING = 0.5;
    public static int DEFAULT_MINIMUM_SCORES = 10;
    public static double DEFAULT_LOWER_THRESHOLD = 0.9;
    public static double DEFAULT_LOWER_THRESHOLD_NORMALIZED = 0.8;
    public static double DEFAULT_ABSOLUTE_THRESHOLD = 0.7;
    public static double DEFAULT_INITIAL_THRESHOLD = 1.5;
    public static double DEFAULT_Z_FACTOR = 3.0;
    public static double MINIMUM_Z_FACTOR = 2.0;
    public static boolean DEFAULT_AUTO_THRESHOLD = true;
    public static int DEFAULT_DEVIATION_STATES = 3;
    protected int count = 0;
    protected double scoreDifferencing = DEFAULT_SCORE_DIFFERENCING;
    protected int minimumScores = DEFAULT_MINIMUM_SCORES;
    protected Deviation primaryDeviation;
    protected Deviation secondaryDeviation;
    protected Deviation thresholdDeviation;
    protected boolean autoThreshold = DEFAULT_AUTO_THRESHOLD;
    protected double absoluteThreshold = DEFAULT_ABSOLUTE_THRESHOLD;
    protected double lowerThreshold = DEFAULT_LOWER_THRESHOLD;
    protected double initialThreshold = DEFAULT_INITIAL_THRESHOLD;
    protected double zFactor = DEFAULT_Z_FACTOR;

    public BasicThresholder(double primaryDiscount, double secondaryDiscount, boolean adjust) {
        this.primaryDeviation = new Deviation(primaryDiscount);
        this.secondaryDeviation = new Deviation(secondaryDiscount);
        this.thresholdDeviation = new Deviation(primaryDiscount / 2.0);
        this.autoThreshold = adjust;
    }

    public BasicThresholder(double discount) {
        this(discount, discount, false);
    }

    public BasicThresholder(Deviation[] deviations) {
        if (deviations == null || deviations.length != DEFAULT_DEVIATION_STATES) {
            double timeDecay = 3.90625E-4;
            this.primaryDeviation = new Deviation(timeDecay);
            this.secondaryDeviation = new Deviation(timeDecay);
            this.thresholdDeviation = new Deviation(0.1 * timeDecay);
        } else {
            this.primaryDeviation = deviations[0];
            this.secondaryDeviation = deviations[1];
            this.thresholdDeviation = deviations[2];
        }
    }

    public BasicThresholder(List<Double> scores, double rate) {
        this.primaryDeviation = new Deviation(0.0);
        this.secondaryDeviation = new Deviation(0.0);
        this.thresholdDeviation = new Deviation(0.0);
        if (scores != null) {
            scores.forEach(s -> this.update((double)s, (double)s));
        }
        this.primaryDeviation.setDiscount(rate);
        this.secondaryDeviation.setDiscount(rate);
        this.thresholdDeviation.setDiscount(0.1 * rate);
    }

    public boolean isDeviationReady() {
        if (this.count < this.minimumScores) {
            return false;
        }
        if (this.scoreDifferencing == 0.0) {
            return this.secondaryDeviation.getCount() >= this.minimumScores;
        }
        if (this.scoreDifferencing == 1.0) {
            return this.primaryDeviation.getCount() >= this.minimumScores;
        }
        return this.secondaryDeviation.getCount() >= this.minimumScores && this.primaryDeviation.getCount() >= this.minimumScores;
    }

    protected double intermediateTermFraction() {
        if (this.count < this.minimumScores) {
            return 0.0;
        }
        if (this.count > 2 * this.minimumScores) {
            return 1.0;
        }
        return (double)(this.count - this.minimumScores) * 1.0 / (double)this.minimumScores;
    }

    @Deprecated
    public double threshold() {
        return this.getPrimaryThreshold();
    }

    public double getPrimaryThreshold() {
        return this.primaryDeviation.getMean() + this.zFactor * this.primaryDeviation.getDeviation();
    }

    public double getPrimaryGrade(double score) {
        double tFactor = 2.0 * this.zFactor;
        double deviation = this.primaryDeviation.getDeviation();
        if (deviation > 0.0) {
            tFactor = Math.min(tFactor, (score - this.primaryDeviation.getMean()) / deviation);
        }
        double t = (tFactor - this.zFactor) / this.zFactor;
        return Math.max(0.0, t);
    }

    @Deprecated
    public double getAnomalyGrade(double score, boolean flag) {
        return this.getPrimaryGrade(score);
    }

    protected double adjustedFactor(double factor, TransformMethod method, int dimension) {
        double correctedFactor = factor;
        double base = this.primaryDeviation.getMean();
        if (this.autoThreshold && base < this.lowerThreshold && method != TransformMethod.NORMALIZE) {
            correctedFactor = this.primaryDeviation.getMean() * factor / this.lowerThreshold;
        }
        return Math.max(correctedFactor, MINIMUM_Z_FACTOR);
    }

    protected double longTermDeviation(TransformMethod method, int shingleSize) {
        if (shingleSize == 1 && method != TransformMethod.DIFFERENCE && method != TransformMethod.NORMALIZE_DIFFERENCE) {
            return Math.min(Math.sqrt(2.0) * this.thresholdDeviation.getDeviation(), this.primaryDeviation.getDeviation());
        }
        double first = this.primaryDeviation.getDeviation();
        if (method != TransformMethod.NORMALIZE) {
            first = Math.min(first, Math.sqrt(2.0) * this.thresholdDeviation.getDeviation());
        }
        return this.scoreDifferencing * first + (1.0 - this.scoreDifferencing) * this.secondaryDeviation.getDeviation();
    }

    public Weighted<Double> getThresholdAndGrade(double score, TransformMethod method, int dimension, int shingleSize) {
        return this.getThresholdAndGrade(score, this.zFactor, method, dimension, shingleSize);
    }

    public Weighted<Double> getThresholdAndGrade(double score, double factor, TransformMethod method, int dimension, int shingleSize) {
        double threshold;
        double intermediateFraction = this.intermediateTermFraction();
        double newFactor = this.adjustedFactor(factor, method, dimension);
        double longTerm = this.longTermDeviation(method, shingleSize);
        double scaledDeviation = (newFactor - 1.0) * longTerm + this.primaryDeviation.getDeviation();
        double d = threshold = !this.isDeviationReady() ? Math.max(this.initialThreshold, this.absoluteThreshold) : Math.max(this.absoluteThreshold, intermediateFraction * (this.primaryDeviation.getMean() + scaledDeviation) + (1.0 - intermediateFraction) * this.initialThreshold);
        if (score < threshold) {
            return new Weighted((Object)threshold, 0.0f);
        }
        double base = Math.min(threshold, this.primaryDeviation.getMean());
        return new Weighted((Object)threshold, this.getSurpriseIndex(score, base, newFactor, scaledDeviation / newFactor));
    }

    protected float getSurpriseIndex(double score, double base, double factor, double deviation) {
        double tFactor = 2.0 * factor;
        if (deviation > 0.0) {
            tFactor = Math.min(tFactor, (score - base) / deviation);
        }
        return Math.max(0.0f, (float)((tFactor - factor) / factor));
    }

    protected void updateThreshold(double score) {
        double gap = this.primaryDeviation.getMean() - score;
        if (gap > 0.0) {
            this.thresholdDeviation.update(gap);
        }
    }

    protected void updatePrimary(double score) {
        this.updateThreshold(score);
        this.primaryDeviation.update(score);
        ++this.count;
    }

    public void update(double primary, double secondary) {
        this.updateThreshold(primary);
        this.primaryDeviation.update(primary);
        this.secondaryDeviation.update(secondary);
        ++this.count;
    }

    public void update(double score, double secondScore, double lastScore, TransformMethod method) {
        this.update(score, secondScore - lastScore);
    }

    public Deviation getPrimaryDeviation() {
        return this.primaryDeviation;
    }

    public Deviation getSecondaryDeviation() {
        return this.secondaryDeviation;
    }

    public Deviation getThresholdDeviation() {
        return this.thresholdDeviation;
    }

    public void setZfactor(double factor) {
        this.zFactor = factor;
    }

    public void setLowerThreshold(double lower) {
        this.lowerThreshold = lower;
    }

    public void setAbsoluteThreshold(double value) {
        this.absoluteThreshold = value;
    }

    public void setInitialThreshold(double initial) {
        this.initialThreshold = initial;
    }

    public void setScoreDifferencing(double horizon) {
        CommonUtils.checkArgument((horizon >= 0.0 && horizon <= 1.0 ? 1 : 0) != 0, (String)"incorrect threshold horizon parameter");
        this.scoreDifferencing = horizon;
    }

    public Deviation[] getDeviations() {
        Deviation[] deviations = new Deviation[DEFAULT_DEVIATION_STATES];
        deviations[0] = this.primaryDeviation.copy();
        deviations[1] = this.secondaryDeviation.copy();
        deviations[2] = this.thresholdDeviation.copy();
        return deviations;
    }

    public boolean isAutoThreshold() {
        return this.autoThreshold;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public double getAbsoluteThreshold() {
        return this.absoluteThreshold;
    }

    public double getInitialThreshold() {
        return this.initialThreshold;
    }

    public double getLowerThreshold() {
        return this.lowerThreshold;
    }

    public double getScoreDifferencing() {
        return this.scoreDifferencing;
    }

    public double getZFactor() {
        return this.zFactor;
    }

    public int getMinimumScores() {
        return this.minimumScores;
    }

    public void setMinimumScores(int minimumScores) {
        this.minimumScores = minimumScores;
    }

    public void setAutoThreshold(boolean autoThreshold) {
        this.autoThreshold = autoThreshold;
    }
}

