/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rdsdata.model.Field;

public class MappingException
extends RuntimeException {
    static final String ERROR_NO_FIELD_OR_SETTER = "Class '%s' does not contain field '%s' or a corresponding setter";
    static final String ERROR_CANNOT_ACCESS_FIELD = "Cannot access field '%s' in class %s";
    static final String ERROR_CANNOT_CREATE_INSTANCE = "Cannot create instance of type %s";
    static final String ERROR_CANNOT_CREATE_INSTANCE_VIA_NOARGS = "Cannot create instance of type %s: public no args constructor not found";
    static final String ERROR_STATIC_FIELD = "Field '%s' in class %s is static";
    static final String ERROR_CANNOT_SET_VALUE = "Cannot set value '%s'";
    static final String ERROR_EMPTY_RESULT_SET = "Result set is empty";
    static final String ERROR_CANNOT_CONVERT_TO_TYPE = "Cannot convert field %s to type %s";
    static final String ERROR_AMBIGUOUS_SETTER = "Ambiguous setter for field %s. Possible setters found: %s";

    private MappingException(String message) {
        super(message);
    }

    private MappingException(String message, Throwable cause) {
        super(message, cause);
    }

    static MappingException noFieldOrSetter(Class<?> clazz, String fieldName) {
        String message = String.format(ERROR_NO_FIELD_OR_SETTER, clazz.getName(), fieldName);
        return new MappingException(message);
    }

    static MappingException cannotAccessField(Class<?> clazz, String fieldName) {
        String message = String.format(ERROR_CANNOT_ACCESS_FIELD, fieldName, clazz.getName());
        return new MappingException(message);
    }

    static MappingException cannotCreateInstanceViaNoArgsConstructor(Class<?> clazz) {
        String message = String.format(ERROR_CANNOT_CREATE_INSTANCE_VIA_NOARGS, clazz.getName());
        return new MappingException(message);
    }

    static MappingException cannotCreateInstance(Class<?> clazz, Throwable cause) {
        String message = String.format(ERROR_CANNOT_CREATE_INSTANCE, clazz.getName());
        return new MappingException(message, cause);
    }

    static MappingException staticField(Class<?> clazz, String fieldName) {
        String message = String.format(ERROR_STATIC_FIELD, fieldName, clazz.getName());
        return new MappingException(message);
    }

    static MappingException cannotSetValue(String fieldName, Throwable cause) {
        String message = String.format(ERROR_CANNOT_SET_VALUE, fieldName);
        return new MappingException(message, cause);
    }

    static MappingException emptyResultSet() {
        return new MappingException(ERROR_EMPTY_RESULT_SET);
    }

    static MappingException cannotConvertToType(Field field, Class targetType) {
        String message = String.format(ERROR_CANNOT_CONVERT_TO_TYPE, field.toString(), targetType.toString());
        return new MappingException(message);
    }

    static MappingException ambiguousSetter(String fieldName, List<Method> possibleSetters) {
        String settersListString = possibleSetters.stream().map(Method::toString).collect(Collectors.joining(", "));
        String message = String.format(ERROR_AMBIGUOUS_SETTER, fieldName, settersListString);
        return new MappingException(message);
    }
}

