/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.Executor;
import com.amazon.rdsdata.client.MappingOptions;
import com.amazon.rdsdata.client.PlaceholderUtils;
import com.amazon.rdsdata.client.TypeConverter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rdsdata.RdsDataClient;
import software.amazon.awssdk.services.rdsdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.BeginTransactionResponse;
import software.amazon.awssdk.services.rdsdata.model.CommitTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.DecimalReturnType;
import software.amazon.awssdk.services.rdsdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.rdsdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.rdsdata.model.ResultSetOptions;
import software.amazon.awssdk.services.rdsdata.model.RollbackTransactionRequest;
import software.amazon.awssdk.services.rdsdata.model.SqlParameter;

public class RdsData {
    static String ERROR_EMPTY_OR_NULL_SQL = "SQL parameter is null or empty";
    private RdsDataClient sdkClient;
    private String database;
    private String secretArn;
    private String resourceArn;
    private MappingOptions mappingOptions;

    public String beginTransaction() {
        BeginTransactionRequest request = (BeginTransactionRequest)BeginTransactionRequest.builder().database(this.database).resourceArn(this.resourceArn).secretArn(this.secretArn).build();
        BeginTransactionResponse response = this.sdkClient.beginTransaction(request);
        return response.transactionId();
    }

    public void commitTransaction(String transactionId) {
        CommitTransactionRequest request = (CommitTransactionRequest)CommitTransactionRequest.builder().transactionId(transactionId).resourceArn(this.resourceArn).secretArn(this.secretArn).build();
        this.sdkClient.commitTransaction(request);
    }

    public void rollbackTransaction(String transactionId) {
        RollbackTransactionRequest request = (RollbackTransactionRequest)RollbackTransactionRequest.builder().transactionId(transactionId).resourceArn(this.resourceArn).secretArn(this.secretArn).build();
        this.sdkClient.rollbackTransaction(request);
    }

    public Executor forSql(String sql) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)ERROR_EMPTY_OR_NULL_SQL);
        return new Executor(sql, this);
    }

    public Executor forSql(String sql, Object ... params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sql) ? 1 : 0) != 0, (Object)ERROR_EMPTY_OR_NULL_SQL);
        if (params == null) {
            params = new Object[]{null};
        }
        PlaceholderUtils.PlaceholderConvertResult result = PlaceholderUtils.convertToNamed(sql, params);
        return new Executor(result.sql, this).withParamSets(Collections.singletonList(result.parameters));
    }

    ExecutionResult executeStatement(String transactionId, String sql, Map<String, Object> params, boolean continueAfterTimeout) {
        ExecuteStatementRequest request = (ExecuteStatementRequest)ExecuteStatementRequest.builder().database(this.database).resourceArn(this.resourceArn).secretArn(this.secretArn).sql(sql).parameters(this.toSqlParameterList(params)).transactionId(transactionId).continueAfterTimeout(Boolean.valueOf(continueAfterTimeout)).resultSetOptions((ResultSetOptions)ResultSetOptions.builder().decimalReturnType(DecimalReturnType.STRING).build()).includeResultMetadata(Boolean.valueOf(true)).build();
        ExecuteStatementResponse response = this.sdkClient.executeStatement(request);
        return new ExecutionResult(response.columnMetadata(), response.records(), response.numberOfRecordsUpdated(), this.mappingOptions);
    }

    ExecutionResult batchExecuteStatement(String transactionId, String sql, List<Map<String, Object>> params) {
        BatchExecuteStatementRequest request = (BatchExecuteStatementRequest)BatchExecuteStatementRequest.builder().database(this.database).resourceArn(this.resourceArn).secretArn(this.secretArn).sql(sql).transactionId(transactionId).parameterSets(this.toSqlParameterSets(params)).build();
        this.sdkClient.batchExecuteStatement(request);
        return new ExecutionResult(Collections.emptyList(), Collections.emptyList(), 0L, this.mappingOptions);
    }

    private List<SqlParameter> toSqlParameterList(Map<String, Object> params) {
        return params.entrySet().stream().map(this::toSqlParameter).collect(Collectors.toList());
    }

    private SqlParameter toSqlParameter(Map.Entry<String, Object> mapEntry) {
        String parameterName = mapEntry.getKey();
        Object value = mapEntry.getValue();
        SqlParameter.Builder parameterBuilder = SqlParameter.builder().name(parameterName).value(TypeConverter.toField(value));
        TypeConverter.getTypeHint(value).ifPresent(hint -> parameterBuilder.typeHint(hint.name()));
        return (SqlParameter)parameterBuilder.build();
    }

    private List<List<SqlParameter>> toSqlParameterSets(List<Map<String, Object>> params) {
        return params.stream().map(this::toSqlParameterList).collect(Collectors.toList());
    }

    private static MappingOptions $default$mappingOptions() {
        return MappingOptions.DEFAULT;
    }

    RdsData(RdsDataClient sdkClient, String database, String secretArn, String resourceArn, MappingOptions mappingOptions) {
        this.sdkClient = sdkClient;
        this.database = database;
        this.secretArn = secretArn;
        this.resourceArn = resourceArn;
        this.mappingOptions = mappingOptions;
    }

    public static RdsDataBuilder builder() {
        return new RdsDataBuilder();
    }

    public RdsData withDatabase(String database) {
        return this.database == database ? this : new RdsData(this.sdkClient, database, this.secretArn, this.resourceArn, this.mappingOptions);
    }

    public RdsData withMappingOptions(MappingOptions mappingOptions) {
        return this.mappingOptions == mappingOptions ? this : new RdsData(this.sdkClient, this.database, this.secretArn, this.resourceArn, mappingOptions);
    }

    public static class RdsDataBuilder {
        private RdsDataClient sdkClient;
        private String database;
        private String secretArn;
        private String resourceArn;
        private boolean mappingOptions$set;
        private MappingOptions mappingOptions$value;

        RdsDataBuilder() {
        }

        public RdsDataBuilder sdkClient(RdsDataClient sdkClient) {
            this.sdkClient = sdkClient;
            return this;
        }

        public RdsDataBuilder database(String database) {
            this.database = database;
            return this;
        }

        public RdsDataBuilder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public RdsDataBuilder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public RdsDataBuilder mappingOptions(MappingOptions mappingOptions) {
            this.mappingOptions$value = mappingOptions;
            this.mappingOptions$set = true;
            return this;
        }

        public RdsData build() {
            MappingOptions mappingOptions$value = this.mappingOptions$value;
            if (!this.mappingOptions$set) {
                mappingOptions$value = RdsData.$default$mappingOptions();
            }
            return new RdsData(this.sdkClient, this.database, this.secretArn, this.resourceArn, mappingOptions$value);
        }

        public String toString() {
            return "RdsData.RdsDataBuilder(sdkClient=" + this.sdkClient + ", database=" + this.database + ", secretArn=" + this.secretArn + ", resourceArn=" + this.resourceArn + ", mappingOptions$value=" + this.mappingOptions$value + ")";
        }
    }
}

