/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.rulesengine.language.Endpoint;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.expressions.literal.Literal;
import software.amazon.smithy.rulesengine.validators.AuthSchemeValidator;
import software.amazon.smithy.rulesengine.validators.RuleSetAuthSchemesValidator;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

public final class EndpointAuthUtils {
    private static final String SIGV_4 = "sigv4";
    private static final String SIG_V4A = "sigv4a";
    private static final String SIGNING_NAME = "signingName";
    private static final String SIGNING_REGION = "signingRegion";
    private static final String SIGNING_REGION_SET = "signingRegionSet";
    private static final Identifier DISABLE_DOUBLE_ENCODING = Identifier.of((String)"disableDoubleEncoding");
    private static final Identifier DISABLE_NORMALIZE_PATH = Identifier.of((String)"disableNormalizePath");

    private EndpointAuthUtils() {
    }

    public static Endpoint.Builder sigv4(Endpoint.Builder builder, Literal signingRegion, Literal signingService) {
        return builder.addAuthScheme(SIGV_4, MapUtils.of((Object)SIGNING_NAME, (Object)signingService, (Object)SIGNING_REGION, (Object)signingRegion));
    }

    public static Endpoint.Builder sigv4a(Endpoint.Builder builder, List<Literal> signingRegionSet, Literal signingService) {
        return builder.addAuthScheme(SIG_V4A, MapUtils.of((Object)SIGNING_NAME, (Object)signingService, (Object)SIGNING_REGION_SET, (Object)Literal.tupleLiteral(signingRegionSet)));
    }

    private static List<ValidationEvent> noExtraProperties(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, SourceLocation sourceLocation, Map<Identifier, Literal> properties, List<Identifier> allowedProperties) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Identifier propertyName : properties.keySet()) {
            if (allowedProperties.contains(propertyName)) continue;
            events.add(emitter.apply((FromSourceLocation)sourceLocation, String.format("Unexpected key: `%s` (valid keys: %s)", propertyName, allowedProperties)));
        }
        return events;
    }

    private static <U> Optional<ValidationEvent> validatePropertyType(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> properties, Identifier propertyName, Function<Literal, Optional<U>> validator) {
        Literal value = properties.get(propertyName);
        if (value == null) {
            return Optional.of(emitter.apply((FromSourceLocation)propertyName, String.format("Expected auth property `%s` but didn't find one", propertyName)));
        }
        if (!validator.apply(value).isPresent()) {
            return Optional.of(emitter.apply((FromSourceLocation)value, String.format("Unexpected type for auth property `%s`, found: `%s`", propertyName, value)));
        }
        return Optional.empty();
    }

    static final class BetaSchemeValidator
    implements AuthSchemeValidator {
        BetaSchemeValidator() {
        }

        public boolean test(String name) {
            return name.startsWith("beta-");
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, SourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            Identifier signingName = Identifier.of((String)EndpointAuthUtils.SIGNING_NAME);
            List<ValidationEvent> events = this.hasAllKeys(emitter, authScheme, ListUtils.of((Object)RuleSetAuthSchemesValidator.NAME, (Object)signingName), sourceLocation);
            EndpointAuthUtils.validatePropertyType(emitter, authScheme, signingName, Literal::asStringLiteral).ifPresent(events::add);
            return events;
        }

        private List<ValidationEvent> hasAllKeys(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> authScheme, List<Identifier> requiredKeys, SourceLocation sourceLocation) {
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            for (Identifier key : requiredKeys) {
                if (authScheme.containsKey(key)) continue;
                emitter.apply((FromSourceLocation)sourceLocation, String.format("Missing key: `%s`", key));
            }
            return events;
        }
    }

    static final class SigV4aSchemeValidator
    implements AuthSchemeValidator {
        SigV4aSchemeValidator() {
        }

        public boolean test(String name) {
            return name.equals(EndpointAuthUtils.SIG_V4A);
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, SourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            Identifier signingRegionSet = Identifier.of((String)EndpointAuthUtils.SIGNING_REGION_SET);
            Identifier signingName = Identifier.of((String)EndpointAuthUtils.SIGNING_NAME);
            List events = EndpointAuthUtils.noExtraProperties(emitter, sourceLocation, authScheme, ListUtils.of((Object[])new Identifier[]{RuleSetAuthSchemesValidator.NAME, signingName, signingRegionSet, DISABLE_DOUBLE_ENCODING, DISABLE_NORMALIZE_PATH}));
            EndpointAuthUtils.validatePropertyType(emitter, authScheme, signingName, Literal::asStringLiteral).ifPresent(events::add);
            EndpointAuthUtils.validatePropertyType(emitter, authScheme, signingRegionSet, Literal::asTupleLiteral).ifPresent(events::add);
            return events;
        }
    }

    static final class SigV4SchemeValidator
    implements AuthSchemeValidator {
        SigV4SchemeValidator() {
        }

        public boolean test(String name) {
            return name.equals(EndpointAuthUtils.SIGV_4);
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, SourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            Identifier signingRegion = Identifier.of((String)EndpointAuthUtils.SIGNING_REGION);
            Identifier signingName = Identifier.of((String)EndpointAuthUtils.SIGNING_NAME);
            List events = EndpointAuthUtils.noExtraProperties(emitter, sourceLocation, authScheme, ListUtils.of((Object[])new Identifier[]{RuleSetAuthSchemesValidator.NAME, signingName, signingRegion, DISABLE_DOUBLE_ENCODING, DISABLE_NORMALIZE_PATH}));
            EndpointAuthUtils.validatePropertyType(emitter, authScheme, signingName, Literal::asStringLiteral).ifPresent(events::add);
            EndpointAuthUtils.validatePropertyType(emitter, authScheme, signingRegion, Literal::asStringLiteral).ifPresent(events::add);
            return events;
        }
    }
}

