/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.smithy.rulesengine.language.evaluation.type.Type;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.ToExpression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Expression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.ExpressionVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionDefinition;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionNode;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.LibraryFunction;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class IsVirtualHostableS3Bucket
extends LibraryFunction {
    public static final String ID = "aws.isVirtualHostableS3Bucket";
    private static final Definition DEFINITION = new Definition();

    private IsVirtualHostableS3Bucket(FunctionNode functionNode) {
        super((FunctionDefinition)DEFINITION, functionNode);
    }

    public static Definition getDefinition() {
        return DEFINITION;
    }

    public static IsVirtualHostableS3Bucket ofExpressions(ToExpression arg1, ToExpression arg2) {
        return DEFINITION.createFunction(FunctionNode.ofExpressions((String)ID, (ToExpression[])new ToExpression[]{arg1, arg2}));
    }

    public static IsVirtualHostableS3Bucket ofExpressions(ToExpression arg1, boolean arg2) {
        return IsVirtualHostableS3Bucket.ofExpressions(arg1, (ToExpression)Expression.of((boolean)arg2));
    }

    public <T> T accept(ExpressionVisitor<T> visitor) {
        return (T)visitor.visitLibraryFunction((FunctionDefinition)DEFINITION, this.getArguments());
    }

    public static final class Definition
    implements FunctionDefinition {
        private static final Pattern DOTS_ALLOWED = Pattern.compile("[a-z\\d][a-z\\d\\-.]{1,61}[a-z\\d]");
        private static final Pattern DOTS_DISALLOWED = Pattern.compile("[a-z\\d][a-z\\d\\-]{1,61}[a-z\\d]");
        private static final Pattern IP_ADDRESS = Pattern.compile("(\\d+\\.){3}\\d+");
        private static final Pattern DASH_DOT_SEPARATOR = Pattern.compile(".*[.-]{2}.*");

        private Definition() {
        }

        public String getId() {
            return IsVirtualHostableS3Bucket.ID;
        }

        public List<Type> getArguments() {
            return Arrays.asList(Type.stringType(), Type.booleanType());
        }

        public Type getReturnType() {
            return Type.booleanType();
        }

        public Value evaluate(List<Value> arguments) {
            String hostLabel = arguments.get(0).expectStringValue().getValue();
            boolean allowDots = arguments.get(1).expectBooleanValue().getValue();
            if (allowDots) {
                return Value.booleanValue((DOTS_ALLOWED.matcher(hostLabel).matches() && !IP_ADDRESS.matcher(hostLabel).matches() && !DASH_DOT_SEPARATOR.matcher(hostLabel).matches() ? 1 : 0) != 0);
            }
            return Value.booleanValue((boolean)DOTS_DISALLOWED.matcher(hostLabel).matches());
        }

        public IsVirtualHostableS3Bucket createFunction(FunctionNode functionNode) {
            return new IsVirtualHostableS3Bucket(functionNode);
        }
    }
}

