/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.rulesengine.aws.language.functions.AwsArn;
import software.amazon.smithy.rulesengine.language.evaluation.type.Type;
import software.amazon.smithy.rulesengine.language.evaluation.value.StringValue;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.ToExpression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.ExpressionVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionDefinition;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionNode;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.LibraryFunction;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class ParseArn
extends LibraryFunction {
    public static final String ID = "aws.parseArn";
    public static final Identifier PARTITION = Identifier.of((String)"partition");
    public static final Identifier SERVICE = Identifier.of((String)"service");
    public static final Identifier REGION = Identifier.of((String)"region");
    public static final Identifier ACCOUNT_ID = Identifier.of((String)"accountId");
    private static final Identifier RESOURCE_ID = Identifier.of((String)"resourceId");
    private static final Definition DEFINITION = new Definition();

    private ParseArn(FunctionNode functionNode) {
        super((FunctionDefinition)DEFINITION, functionNode);
    }

    public static Definition getDefinition() {
        return DEFINITION;
    }

    public static ParseArn ofExpressions(ToExpression arg1) {
        return DEFINITION.createFunction(FunctionNode.ofExpressions((String)ID, (ToExpression[])new ToExpression[]{arg1}));
    }

    public <T> T accept(ExpressionVisitor<T> visitor) {
        return (T)visitor.visitLibraryFunction((FunctionDefinition)DEFINITION, this.getArguments());
    }

    public static final class Definition
    implements FunctionDefinition {
        private final Type returnType;

        private Definition() {
            LinkedHashMap<Identifier, Object> types = new LinkedHashMap<Identifier, Object>();
            types.put(PARTITION, Type.stringType());
            types.put(SERVICE, Type.stringType());
            types.put(REGION, Type.stringType());
            types.put(ACCOUNT_ID, Type.stringType());
            types.put(RESOURCE_ID, Type.arrayType((Type)Type.stringType()));
            this.returnType = Type.optionalType((Type)Type.recordType(types));
        }

        public String getId() {
            return ParseArn.ID;
        }

        public List<Type> getArguments() {
            return Collections.singletonList(Type.stringType());
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Value evaluate(List<Value> arguments) {
            String value = arguments.get(0).expectStringValue().getValue();
            Optional<AwsArn> arnOpt = AwsArn.parse(value);
            if (!arnOpt.isPresent()) {
                return Value.emptyValue();
            }
            AwsArn awsArn = arnOpt.get();
            ArrayList<StringValue> resourceId = new ArrayList<StringValue>();
            for (String resourceIdPart : awsArn.getResource()) {
                resourceId.add(Value.stringValue((String)resourceIdPart));
            }
            return Value.recordValue((Map)MapUtils.of((Object)PARTITION, (Object)Value.stringValue((String)awsArn.getPartition()), (Object)SERVICE, (Object)Value.stringValue((String)awsArn.getService()), (Object)REGION, (Object)Value.stringValue((String)awsArn.getRegion()), (Object)ACCOUNT_ID, (Object)Value.stringValue((String)awsArn.getAccountId()), (Object)RESOURCE_ID, (Object)Value.arrayValue(resourceId)));
        }

        public ParseArn createFunction(FunctionNode functionNode) {
            return new ParseArn(functionNode);
        }
    }
}

