/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class AwsArn
implements ToSmithyBuilder<AwsArn> {
    private final String partition;
    private final String service;
    private final String region;
    private final String accountId;
    private final List<String> resource;

    private AwsArn(Builder builder) {
        this.partition = (String)SmithyBuilder.requiredState((String)"partition", (Object)builder.partition);
        this.service = (String)SmithyBuilder.requiredState((String)"service", (Object)builder.service);
        this.region = (String)SmithyBuilder.requiredState((String)"region", (Object)builder.region);
        this.accountId = (String)SmithyBuilder.requiredState((String)"accountId", (Object)builder.accountId);
        this.resource = (List)builder.resource.copy();
    }

    public static Optional<AwsArn> parse(String arn) {
        String[] base = arn.split(":", 6);
        if (base.length != 6) {
            return Optional.empty();
        }
        if (!base[0].equals("arn")) {
            return Optional.empty();
        }
        if (base[1].isEmpty() || base[2].isEmpty() || base[5].isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(AwsArn.builder().partition(base[1]).service(base[2]).region(base[3]).accountId(base[4]).resource(Arrays.asList(base[5].split("[:/]", -1))).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPartition() {
        return this.partition;
    }

    public String getService() {
        return this.service;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.service, this.region, this.accountId, this.resource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsArn awsArn = (AwsArn)o;
        return this.partition.equals(awsArn.partition) && this.service.equals(awsArn.service) && this.region.equals(awsArn.region) && this.accountId.equals(awsArn.accountId) && this.resource.equals(awsArn.resource);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.resource.forEach(builder::append);
        return "Arn[partition=" + this.partition + ", service=" + this.service + ", region=" + this.region + ", accountId=" + this.accountId + ", resource=" + builder + "]";
    }

    public Builder toBuilder() {
        return AwsArn.builder().partition(this.partition).service(this.service).region(this.region).accountId(this.accountId).resource(this.resource);
    }

    public static final class Builder
    implements SmithyBuilder<AwsArn> {
        private final BuilderRef<List<String>> resource = BuilderRef.forList();
        private String partition;
        private String service;
        private String region;
        private String accountId;

        private Builder() {
        }

        public Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder resource(List<String> resource) {
            this.resource.clear();
            ((List)this.resource.get()).addAll(resource);
            return this;
        }

        public AwsArn build() {
            return new AwsArn(this);
        }
    }
}

