/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.rulesengine.language.Endpoint;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.expressions.literal.Literal;
import software.amazon.smithy.rulesengine.validators.AuthSchemeValidator;
import software.amazon.smithy.rulesengine.validators.RuleSetAuthSchemesValidator;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

public final class EndpointAuthUtils {
    private static final String SIGV_4 = "sigv4";
    private static final String SIG_V4A = "sigv4a";
    private static final String SIGNING_NAME = "signingName";
    private static final String SIGNING_REGION = "signingRegion";
    private static final String SIGNING_REGION_SET = "signingRegionSet";
    private static final Identifier ID_SIGNING_NAME = Identifier.of((String)"signingName");
    private static final Identifier ID_SIGNING_REGION = Identifier.of((String)"signingRegion");
    private static final Identifier ID_SIGNING_REGION_SET = Identifier.of((String)"signingRegionSet");
    private static final Identifier ID_DISABLE_DOUBLE_ENCODING = Identifier.of((String)"disableDoubleEncoding");
    private static final Identifier ID_DISABLE_NORMALIZE_PATH = Identifier.of((String)"disableNormalizePath");

    private EndpointAuthUtils() {
    }

    public static Endpoint.Builder sigv4(Endpoint.Builder builder, Literal signingRegion, Literal signingService) {
        return builder.addAuthScheme(SIGV_4, MapUtils.of((Object)SIGNING_NAME, (Object)signingService, (Object)SIGNING_REGION, (Object)signingRegion));
    }

    public static Endpoint.Builder sigv4a(Endpoint.Builder builder, List<Literal> signingRegionSet, Literal signingService) {
        return builder.addAuthScheme(SIG_V4A, MapUtils.of((Object)SIGNING_NAME, (Object)signingService, (Object)SIGNING_REGION_SET, (Object)Literal.tupleLiteral(signingRegionSet)));
    }

    private static List<ValidationEvent> noExtraProperties(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, FromSourceLocation sourceLocation, Map<Identifier, Literal> properties, List<Identifier> allowedProperties) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Identifier propertyName : properties.keySet()) {
            if (allowedProperties.contains(propertyName)) continue;
            events.add(emitter.apply(sourceLocation, String.format("Unexpected key: `%s` (valid keys: %s)", propertyName, allowedProperties)));
        }
        return events;
    }

    private static Optional<ValidationEvent> validateBooleanProperty(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> properties, Identifier propertyName) {
        return EndpointAuthUtils.validatePropertyType(emitter, properties.get(propertyName), propertyName, Literal::asBooleanLiteral, "a boolean");
    }

    private static Optional<ValidationEvent> validateStringProperty(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> properties, Identifier propertyName) {
        return EndpointAuthUtils.validatePropertyType(emitter, properties.get(propertyName), propertyName, Literal::asStringLiteral, "a string");
    }

    private static <U> Optional<ValidationEvent> validatePropertyType(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Literal value, Identifier propertyName, Function<Literal, Optional<U>> validator, String expectedType) {
        if (value == null) {
            return Optional.of(emitter.apply((FromSourceLocation)propertyName, String.format("Expected auth property `%s` of %s type but didn't find one", propertyName, expectedType)));
        }
        if (!validator.apply(value).isPresent()) {
            return Optional.of(emitter.apply((FromSourceLocation)value, String.format("Unexpected type for auth property `%s`, found `%s` but expected %s value", propertyName, value, expectedType)));
        }
        return Optional.empty();
    }

    static final class BetaSchemeValidator
    implements AuthSchemeValidator {
        BetaSchemeValidator() {
        }

        public boolean test(String name) {
            return name.startsWith("beta-");
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, FromSourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            List<ValidationEvent> events = this.hasAllKeys(emitter, authScheme, ListUtils.of((Object)RuleSetAuthSchemesValidator.NAME, (Object)ID_SIGNING_NAME), sourceLocation);
            EndpointAuthUtils.validateStringProperty(emitter, authScheme, ID_SIGNING_NAME).ifPresent(events::add);
            return events;
        }

        private List<ValidationEvent> hasAllKeys(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> authScheme, List<Identifier> requiredKeys, FromSourceLocation sourceLocation) {
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            for (Identifier key : requiredKeys) {
                if (authScheme.containsKey(key)) continue;
                emitter.apply(sourceLocation, String.format("Missing key: `%s`", key));
            }
            return events;
        }
    }

    static final class SigV4SubSchemeValidator
    implements AuthSchemeValidator {
        SigV4SubSchemeValidator() {
        }

        public boolean test(String name) {
            return name.startsWith("sigv4-");
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, FromSourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            List<ValidationEvent> events = this.hasAllKeys(emitter, authScheme, ListUtils.of((Object)RuleSetAuthSchemesValidator.NAME, (Object)ID_SIGNING_NAME), sourceLocation);
            EndpointAuthUtils.validateStringProperty(emitter, authScheme, ID_SIGNING_NAME).ifPresent(events::add);
            ValidationEvent event = emitter.apply(sourceLocation, "Requirements for `sigv4-` auth sub-scheme validation may change.");
            events.add(event.toBuilder().severity(Severity.DANGER).build());
            return events;
        }

        private List<ValidationEvent> hasAllKeys(BiFunction<FromSourceLocation, String, ValidationEvent> emitter, Map<Identifier, Literal> authScheme, List<Identifier> requiredKeys, FromSourceLocation sourceLocation) {
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            for (Identifier key : requiredKeys) {
                if (authScheme.containsKey(key)) continue;
                emitter.apply(sourceLocation, String.format("Missing key: `%s`", key));
            }
            return events;
        }
    }

    static final class SigV4aSchemeValidator
    implements AuthSchemeValidator {
        SigV4aSchemeValidator() {
        }

        public boolean test(String name) {
            return name.equals(EndpointAuthUtils.SIG_V4A);
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, FromSourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            List events = EndpointAuthUtils.noExtraProperties(emitter, sourceLocation, authScheme, ListUtils.of((Object[])new Identifier[]{RuleSetAuthSchemesValidator.NAME, ID_SIGNING_NAME, ID_SIGNING_REGION_SET, ID_DISABLE_DOUBLE_ENCODING, ID_DISABLE_NORMALIZE_PATH}));
            Optional event = EndpointAuthUtils.validatePropertyType(emitter, authScheme.get(ID_SIGNING_REGION_SET), ID_SIGNING_REGION_SET, Literal::asTupleLiteral, "an array<string>");
            if (event.isPresent()) {
                events.add((ValidationEvent)event.get());
            } else {
                List signingRegionSet = (List)authScheme.get(ID_SIGNING_REGION_SET).asTupleLiteral().get();
                if (signingRegionSet.isEmpty()) {
                    events.add(emitter.apply((FromSourceLocation)authScheme.get(ID_SIGNING_REGION_SET), "The `signingRegionSet` property must not be an empty list."));
                } else {
                    for (Literal signingRegion : signingRegionSet) {
                        EndpointAuthUtils.validatePropertyType(emitter, signingRegion, Identifier.of((String)"signingRegionSet.Value"), Literal::asStringLiteral, "a string").ifPresent(events::add);
                    }
                }
            }
            events.addAll(SigV4SchemeValidator.validateOptionalSharedProperties(authScheme, emitter));
            return events;
        }
    }

    static final class SigV4SchemeValidator
    implements AuthSchemeValidator {
        SigV4SchemeValidator() {
        }

        public boolean test(String name) {
            return name.equals(EndpointAuthUtils.SIGV_4);
        }

        public List<ValidationEvent> validateScheme(Map<Identifier, Literal> authScheme, FromSourceLocation sourceLocation, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            List events = EndpointAuthUtils.noExtraProperties(emitter, sourceLocation, authScheme, ListUtils.of((Object[])new Identifier[]{RuleSetAuthSchemesValidator.NAME, ID_SIGNING_NAME, ID_SIGNING_REGION, ID_DISABLE_DOUBLE_ENCODING, ID_DISABLE_NORMALIZE_PATH}));
            events.addAll(SigV4SchemeValidator.validateOptionalSharedProperties(authScheme, emitter));
            if (authScheme.containsKey(ID_SIGNING_REGION)) {
                EndpointAuthUtils.validateStringProperty(emitter, authScheme, ID_SIGNING_REGION).ifPresent(events::add);
            }
            return events;
        }

        private static List<ValidationEvent> validateOptionalSharedProperties(Map<Identifier, Literal> authScheme, BiFunction<FromSourceLocation, String, ValidationEvent> emitter) {
            ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
            if (authScheme.containsKey(ID_SIGNING_NAME)) {
                EndpointAuthUtils.validateStringProperty(emitter, authScheme, ID_SIGNING_NAME).ifPresent(events::add);
            }
            if (authScheme.containsKey(ID_DISABLE_DOUBLE_ENCODING)) {
                EndpointAuthUtils.validateBooleanProperty(emitter, authScheme, ID_DISABLE_DOUBLE_ENCODING).ifPresent(events::add);
            }
            if (authScheme.containsKey(ID_DISABLE_NORMALIZE_PATH)) {
                EndpointAuthUtils.validateBooleanProperty(emitter, authScheme, ID_DISABLE_NORMALIZE_PATH).ifPresent(events::add);
            }
            return events;
        }
    }
}

