/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.rulesengine.aws.traits.EndpointModifierTrait;

public final class EndpointModifierIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, Trait>> endpointModifierTraits = new HashMap<ShapeId, Map<ShapeId, Trait>>();

    public EndpointModifierIndex(Model model) {
        for (ServiceShape serviceShape : model.getServiceShapes()) {
            TreeMap<ShapeId, Trait> result = new TreeMap<ShapeId, Trait>();
            for (Trait trait : serviceShape.getAllTraits().values()) {
                Shape traitShape = model.expectShape(trait.toShapeId());
                if (!traitShape.hasTrait(EndpointModifierTrait.ID)) continue;
                result.put(trait.toShapeId(), trait);
            }
            this.endpointModifierTraits.put(serviceShape.toShapeId(), result);
        }
    }

    public static EndpointModifierIndex of(Model model) {
        return (EndpointModifierIndex)model.getKnowledge(EndpointModifierIndex.class, EndpointModifierIndex::new);
    }

    public Map<ShapeId, Trait> getEndpointModifierTraits(ToShapeId toShapeId) {
        return this.endpointModifierTraits.get(toShapeId.toShapeId());
    }
}

