/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;

public enum EndpointPatternType {
    SERVICE_DNSSUFFIX("service_dnsSuffix"),
    SERVICE_REGION_DNSSUFFI("service_region_dnsSuffix");

    private final String name;

    private EndpointPatternType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EndpointPatternType fromNode(Node node) {
        StringNode value = node.expectStringNode();
        for (EndpointPatternType type : EndpointPatternType.values()) {
            if (!type.name.equals(value.getValue())) continue;
            return type;
        }
        throw new RuntimeException(String.format("Unable to find EndpointPatternType enum with value [%s]", value.getValue()));
    }
}

