/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class RegionSpecialCase
implements FromSourceLocation,
ToNode,
ToSmithyBuilder<RegionSpecialCase> {
    private static final String ENDPOINT = "endpoint";
    private static final String DUAL_STACK = "dualStack";
    private static final String FIPS = "fips";
    private static final String SIGNING_REGION = "signingRegion";
    private final String endpoint;
    private final Boolean dualStack;
    private final Boolean fips;
    private final String signingRegion;
    private final SourceLocation sourceLocation;

    private RegionSpecialCase(Builder builder) {
        this.endpoint = builder.endpoint;
        this.dualStack = builder.dualStack;
        this.fips = builder.fips;
        this.signingRegion = builder.signingRegion;
        this.sourceLocation = Objects.requireNonNull(builder.sourceLocation);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Boolean getDualStack() {
        return this.dualStack;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public String getSigningRegion() {
        return this.signingRegion;
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(ENDPOINT, this.endpoint).withMember(DUAL_STACK, this.dualStack.toString()).withMember(FIPS, this.fips.toString()).withMember(SIGNING_REGION, this.signingRegion).build();
    }

    public SmithyBuilder<RegionSpecialCase> toBuilder() {
        return new Builder().dualStack(this.dualStack).endpoint(this.endpoint).fips(this.fips).signingRegion(this.signingRegion).sourceLocation(this.sourceLocation);
    }

    public SourceLocation getSourceLocation() {
        return super.getSourceLocation();
    }

    public static RegionSpecialCase fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        return RegionSpecialCase.builder().sourceLocation(objectNode.getSourceLocation()).endpoint(objectNode.expectStringMember(ENDPOINT).getValue()).dualStack(objectNode.getBooleanMemberOrDefault(DUAL_STACK, null)).fips(objectNode.getBooleanMemberOrDefault(FIPS, null)).signingRegion(objectNode.getStringMemberOrDefault(SIGNING_REGION, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<RegionSpecialCase> {
        private String endpoint;
        private Boolean dualStack;
        private Boolean fips;
        private String signingRegion;
        private SourceLocation sourceLocation = SourceLocation.none();

        public RegionSpecialCase build() {
            return new RegionSpecialCase(this);
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint);
            return this;
        }

        public Builder dualStack(Boolean dualStack) {
            this.dualStack = dualStack;
            return this;
        }

        public Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

