/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.rulesengine.aws.traits.EndpointPatternType;
import software.amazon.smithy.rulesengine.aws.traits.PartitionEndpointSpecialCase;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class StandardPartitionalEndpointsTrait
extends AbstractTrait
implements ToSmithyBuilder<StandardPartitionalEndpointsTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.endpoints#standardPartitionalEndpoints");
    public static final String PARTITION_ENDPOINT_SPECIAL_CASES = "partitionEndpointSpecialCases";
    public static final String ENDPOINT_PATTERN_TYPE = "endpointPatternType";
    private final Map<String, List<PartitionEndpointSpecialCase>> partitionEndpointSpecialCases;
    private final EndpointPatternType endpointPatternType;

    public StandardPartitionalEndpointsTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.partitionEndpointSpecialCases = (Map)builder.partitionEndpointSpecialCases.copy();
        this.endpointPatternType = Objects.requireNonNull(builder.endpointPatternType);
    }

    public Map<String, List<PartitionEndpointSpecialCase>> getPartitionEndpointSpecialCases() {
        return this.partitionEndpointSpecialCases;
    }

    public EndpointPatternType getEndpointPatternType() {
        return this.endpointPatternType;
    }

    protected Node createNode() {
        ObjectNode.Builder partitionEndpointSpecialCasesNodeBuilder = ObjectNode.objectNodeBuilder();
        for (Map.Entry<String, List<PartitionEndpointSpecialCase>> entry : this.partitionEndpointSpecialCases.entrySet()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (PartitionEndpointSpecialCase partitionEndpointSpecialCase : entry.getValue()) {
                nodes.add(partitionEndpointSpecialCase.toNode());
            }
            partitionEndpointSpecialCasesNodeBuilder.withMember(entry.getKey(), (ToNode)Node.fromNodes(nodes));
        }
        return ObjectNode.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember(PARTITION_ENDPOINT_SPECIAL_CASES, (ToNode)partitionEndpointSpecialCasesNodeBuilder.build()).withMember(ENDPOINT_PATTERN_TYPE, this.endpointPatternType.getName()).build();
    }

    public SmithyBuilder<StandardPartitionalEndpointsTrait> toBuilder() {
        return new Builder().partitionEndpointSpecialCases(this.partitionEndpointSpecialCases).endpointPatternType(this.endpointPatternType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<StandardPartitionalEndpointsTrait, Builder> {
        private final BuilderRef<Map<String, List<PartitionEndpointSpecialCase>>> partitionEndpointSpecialCases = BuilderRef.forOrderedMap();
        private EndpointPatternType endpointPatternType;

        public Builder partitionEndpointSpecialCases(Map<String, List<PartitionEndpointSpecialCase>> partitionEndpointSpecialCases) {
            this.partitionEndpointSpecialCases.clear();
            ((Map)this.partitionEndpointSpecialCases.get()).putAll(partitionEndpointSpecialCases);
            return this;
        }

        public Builder putPartitionEndpointSpecialCase(String partition, List<PartitionEndpointSpecialCase> partitionEndpointSpecialCases) {
            ((Map)this.partitionEndpointSpecialCases.get()).put(partition, partitionEndpointSpecialCases);
            return this;
        }

        public Builder endpointPatternType(EndpointPatternType endpointPatternType) {
            this.endpointPatternType = endpointPatternType;
            return this;
        }

        public StandardPartitionalEndpointsTrait build() {
            return new StandardPartitionalEndpointsTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            EndpointPatternType endpointPatternType = EndpointPatternType.fromNode((Node)objectNode.expectStringMember(StandardPartitionalEndpointsTrait.ENDPOINT_PATTERN_TYPE));
            Builder builder = ((Builder)StandardPartitionalEndpointsTrait.builder().sourceLocation((FromSourceLocation)value)).endpointPatternType(endpointPatternType);
            if (objectNode.containsMember(StandardPartitionalEndpointsTrait.PARTITION_ENDPOINT_SPECIAL_CASES)) {
                for (Map.Entry entry : objectNode.expectObjectMember(StandardPartitionalEndpointsTrait.PARTITION_ENDPOINT_SPECIAL_CASES).getStringMap().entrySet()) {
                    ArrayList<PartitionEndpointSpecialCase> partitionEndpointSpecialCases = new ArrayList<PartitionEndpointSpecialCase>();
                    for (Node node : ((Node)entry.getValue()).expectArrayNode().getElements()) {
                        partitionEndpointSpecialCases.add(PartitionEndpointSpecialCase.fromNode(node));
                    }
                    builder.putPartitionEndpointSpecialCase((String)entry.getKey(), Collections.unmodifiableList(partitionEndpointSpecialCases));
                }
            }
            StandardPartitionalEndpointsTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

