/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.rulesengine.aws.traits.PartitionSpecialCase;
import software.amazon.smithy.rulesengine.aws.traits.RegionSpecialCase;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class StandardRegionalEndpointsTrait
extends AbstractTrait
implements ToSmithyBuilder<StandardRegionalEndpointsTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.endpoints#standardRegionalEndpoints");
    public static final String PARTITION_SPECIAL_CASES = "partitionSpecialCases";
    public static final String REGION_SPECIAL_CASES = "regionSpecialCases";
    private final Map<String, List<PartitionSpecialCase>> partitionSpecialCases;
    private final Map<String, List<RegionSpecialCase>> regionSpecialCases;

    public StandardRegionalEndpointsTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.partitionSpecialCases = (Map)builder.partitionSpecialCases.copy();
        this.regionSpecialCases = (Map)builder.regionSpecialCases.copy();
    }

    public Map<String, List<PartitionSpecialCase>> getPartitionSpecialCases() {
        return this.partitionSpecialCases;
    }

    public Map<String, List<RegionSpecialCase>> getRegionSpecialCases() {
        return this.regionSpecialCases;
    }

    protected Node createNode() {
        ObjectNode.Builder partitionSpecialCasesNodeBuilder = ObjectNode.objectNodeBuilder();
        for (Map.Entry<String, List<PartitionSpecialCase>> entry : this.partitionSpecialCases.entrySet()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (PartitionSpecialCase partitionSpecialCase : entry.getValue()) {
                nodes.add(partitionSpecialCase.toNode());
            }
            partitionSpecialCasesNodeBuilder.withMember(entry.getKey(), (ToNode)Node.fromNodes(nodes));
        }
        ObjectNode.Builder regionSpecialCasesNodeBuilder = ObjectNode.objectNodeBuilder();
        for (Map.Entry<String, List<RegionSpecialCase>> entry : this.regionSpecialCases.entrySet()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (RegionSpecialCase regionSpecialCase : entry.getValue()) {
                nodes.add(regionSpecialCase.toNode());
            }
            regionSpecialCasesNodeBuilder.withMember(entry.getKey(), (ToNode)Node.fromNodes(nodes));
        }
        return ObjectNode.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember(PARTITION_SPECIAL_CASES, (ToNode)partitionSpecialCasesNodeBuilder.build()).withMember(REGION_SPECIAL_CASES, (ToNode)partitionSpecialCasesNodeBuilder.build()).build();
    }

    public SmithyBuilder<StandardRegionalEndpointsTrait> toBuilder() {
        return new Builder().partitionSpecialCases(this.partitionSpecialCases).regionSpecialCases(this.regionSpecialCases);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<StandardRegionalEndpointsTrait, Builder> {
        private final BuilderRef<Map<String, List<PartitionSpecialCase>>> partitionSpecialCases = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, List<RegionSpecialCase>>> regionSpecialCases = BuilderRef.forOrderedMap();

        public Builder partitionSpecialCases(Map<String, List<PartitionSpecialCase>> partitionSpecialCases) {
            this.partitionSpecialCases.clear();
            ((Map)this.partitionSpecialCases.get()).putAll(partitionSpecialCases);
            return this;
        }

        public Builder putPartitionSpecialCases(String partition, List<PartitionSpecialCase> partitionSpecialCases) {
            ((Map)this.partitionSpecialCases.get()).put(partition, partitionSpecialCases);
            return this;
        }

        public Builder regionSpecialCases(Map<String, List<RegionSpecialCase>> regionSpecialCases) {
            this.regionSpecialCases.clear();
            ((Map)this.regionSpecialCases.get()).putAll(regionSpecialCases);
            return this;
        }

        public Builder putRegionSpecialCases(String region, List<RegionSpecialCase> regionSpecialCases) {
            ((Map)this.regionSpecialCases.get()).put(region, regionSpecialCases);
            return this;
        }

        public StandardRegionalEndpointsTrait build() {
            return new StandardRegionalEndpointsTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)StandardRegionalEndpointsTrait.builder().sourceLocation((FromSourceLocation)value);
            if (objectNode.containsMember(StandardRegionalEndpointsTrait.PARTITION_SPECIAL_CASES)) {
                for (Map.Entry entry : objectNode.expectObjectMember(StandardRegionalEndpointsTrait.PARTITION_SPECIAL_CASES).getStringMap().entrySet()) {
                    ArrayList<PartitionSpecialCase> partitionSpecialCases = new ArrayList<PartitionSpecialCase>();
                    for (Node node : ((Node)entry.getValue()).expectArrayNode().getElements()) {
                        partitionSpecialCases.add(PartitionSpecialCase.fromNode(node));
                    }
                    builder.putPartitionSpecialCases((String)entry.getKey(), Collections.unmodifiableList(partitionSpecialCases));
                }
            }
            if (objectNode.containsMember(StandardRegionalEndpointsTrait.REGION_SPECIAL_CASES)) {
                for (Map.Entry entry : objectNode.expectObjectMember(StandardRegionalEndpointsTrait.REGION_SPECIAL_CASES).getStringMap().entrySet()) {
                    ArrayList<RegionSpecialCase> regionSpecialCases = new ArrayList<RegionSpecialCase>();
                    for (Node node : ((Node)entry.getValue()).expectArrayNode().getElements()) {
                        regionSpecialCases.add(RegionSpecialCase.fromNode(node));
                    }
                    builder.putRegionSpecialCases((String)entry.getKey(), Collections.unmodifiableList(regionSpecialCases));
                }
            }
            StandardRegionalEndpointsTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

