/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.rulesengine.aws.language.functions.AwsBuiltIns;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.rulesengine.traits.EndpointRuleSetTrait;
import software.amazon.smithy.utils.SetUtils;

public class RuleSetAwsBuiltInValidator
extends AbstractValidator {
    private static final Set<String> ADDITIONAL_CONSIDERATION_BUILT_INS = SetUtils.of((Object[])new String[]{(String)AwsBuiltIns.ACCOUNT_ID.getBuiltIn().get(), (String)AwsBuiltIns.CREDENTIAL_SCOPE.getBuiltIn().get()});
    private static final String ADDITIONAL_CONSIDERATION_MESSAGE = "The `%s` built-in used requires additional consideration of the rules that use it.";

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape serviceShape : model.getServiceShapesWithTrait(EndpointRuleSetTrait.class)) {
            events.addAll(this.validateRuleSetAwsBuiltIns(serviceShape, ((EndpointRuleSetTrait)serviceShape.expectTrait(EndpointRuleSetTrait.class)).getEndpointRuleSet()));
        }
        return events;
    }

    private List<ValidationEvent> validateRuleSetAwsBuiltIns(ServiceShape serviceShape, EndpointRuleSet ruleSet) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Parameter parameter : ruleSet.getParameters()) {
            if (!parameter.isBuiltIn()) continue;
            this.validateBuiltIn(serviceShape, (String)parameter.getBuiltIn().get(), (FromSourceLocation)parameter).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateBuiltIn(ServiceShape serviceShape, String builtInName, FromSourceLocation source) {
        if (ADDITIONAL_CONSIDERATION_BUILT_INS.contains(builtInName)) {
            return Optional.of(this.danger((Shape)serviceShape, source, String.format(ADDITIONAL_CONSIDERATION_MESSAGE, builtInName), builtInName));
        }
        return Optional.empty();
    }
}

