/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.validators;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.rulesengine.aws.traits.PartitionEndpointSpecialCase;
import software.amazon.smithy.rulesengine.aws.traits.PartitionSpecialCase;
import software.amazon.smithy.rulesengine.aws.traits.RegionSpecialCase;
import software.amazon.smithy.rulesengine.aws.traits.StandardPartitionalEndpointsTrait;
import software.amazon.smithy.rulesengine.aws.traits.StandardRegionalEndpointsTrait;
import software.amazon.smithy.utils.SetUtils;

public final class AwsSpecialCaseEndpointValidator
extends AbstractValidator {
    private static final Set<String> SUPPORTED_PATTERNS = SetUtils.of((Object[])new String[]{"{region}", "{service}", "{dnsSuffix}", "{dualStackDnsSuffix}"});
    private static final Pattern PATTERN = Pattern.compile("\\{[^\\}]*\\}");

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape serviceShape : model.getServiceShapesWithTrait(StandardRegionalEndpointsTrait.class)) {
            events.addAll(this.validateRegionalEndpointPatterns(serviceShape, (StandardRegionalEndpointsTrait)serviceShape.expectTrait(StandardRegionalEndpointsTrait.class)));
        }
        for (ServiceShape serviceShape : model.getServiceShapesWithTrait(StandardPartitionalEndpointsTrait.class)) {
            events.addAll(this.validatePartitionalEndpointPatterns(serviceShape, (StandardPartitionalEndpointsTrait)serviceShape.expectTrait(StandardPartitionalEndpointsTrait.class)));
        }
        return events;
    }

    private List<ValidationEvent> validateRegionalEndpointPatterns(ServiceShape serviceShape, StandardRegionalEndpointsTrait regionalEndpoints) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (List<RegionSpecialCase> list : regionalEndpoints.getRegionSpecialCases().values()) {
            for (Object specialCase : list) {
                events.addAll(this.validateEndpointPatterns(serviceShape, (FromSourceLocation)regionalEndpoints, ((RegionSpecialCase)specialCase).getEndpoint()));
            }
        }
        for (List<Object> list : regionalEndpoints.getPartitionSpecialCases().values()) {
            for (Object specialCase : list) {
                events.addAll(this.validateEndpointPatterns(serviceShape, (FromSourceLocation)regionalEndpoints, ((PartitionSpecialCase)specialCase).getEndpoint()));
            }
        }
        return events;
    }

    private List<ValidationEvent> validatePartitionalEndpointPatterns(ServiceShape serviceShape, StandardPartitionalEndpointsTrait partitionalEndpoints) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (List<PartitionEndpointSpecialCase> specialCases : partitionalEndpoints.getPartitionEndpointSpecialCases().values()) {
            for (PartitionEndpointSpecialCase specialCase : specialCases) {
                events.addAll(this.validateEndpointPatterns(serviceShape, (FromSourceLocation)partitionalEndpoints, specialCase.getEndpoint()));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateEndpointPatterns(ServiceShape serviceShape, FromSourceLocation location, String endpoint) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Matcher m = PATTERN.matcher(endpoint);
        ArrayList<String> unsupportedPatterns = new ArrayList<String>();
        while (m.find()) {
            if (SUPPORTED_PATTERNS.contains(m.group())) continue;
            unsupportedPatterns.add(m.group());
        }
        if (!unsupportedPatterns.isEmpty()) {
            events.add(this.danger((Shape)serviceShape, location, String.format("Endpoint `%s` contains unsupported patterns: %s", endpoint, String.join((CharSequence)", ", unsupportedPatterns)), "UnsupportedEndpointPattern"));
        }
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            events.add(this.danger((Shape)serviceShape, location, String.format("Endpoint `%s` should start with scheme `http://` or `https://`", endpoint), "InvalidEndpointPatternScheme"));
        }
        if (!this.isValidUrl(endpoint)) {
            events.add(this.error((Shape)serviceShape, location, String.format("Endpoint `%s` should be a valid URL.", endpoint), "InvalidEndpointPatternUrl"));
        }
        return events;
    }

    private boolean isValidUrl(String endpointPattern) {
        String url = endpointPattern.replace("{", "").replace("}", "");
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

