/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions.partition;

import java.util.List;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.Partition;
import software.amazon.smithy.rulesengine.language.RulesComponentBuilder;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class Partitions
implements ToSmithyBuilder<Partitions>,
FromSourceLocation,
ToNode {
    private static final String VERSION = "version";
    private static final String PARTITIONS = "partitions";
    private static final List<String> PROPERTIES = ListUtils.of((Object)"version", (Object)"partitions");
    private final String version;
    private final List<Partition> partitions;
    private final SourceLocation sourceLocation;

    private Partitions(Builder builder) {
        this.sourceLocation = builder.getSourceLocation();
        this.version = builder.version;
        this.partitions = (List)builder.partitions.copy();
    }

    public static Builder builder() {
        return new Builder((FromSourceLocation)SourceLocation.none());
    }

    public static Partitions fromNode(Node node) {
        Builder builder = new Builder((FromSourceLocation)node);
        ObjectNode objNode = node.expectObjectNode();
        objNode.expectNoAdditionalProperties(PROPERTIES);
        objNode.getStringMember(VERSION, builder::version);
        objNode.getArrayMember(PARTITIONS, partitionsNode -> partitionsNode.forEach(partNode -> builder.addPartition(Partition.fromNode(partNode))));
        return builder.build();
    }

    public String getVersion() {
        return this.version;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new Builder((FromSourceLocation)this.getSourceLocation()).version(this.version).partitions(this.partitions);
    }

    public Node toNode() {
        ArrayNode.Builder partitionsNodeBuilder = ArrayNode.builder();
        this.partitions.forEach(arg_0 -> ((ArrayNode.Builder)partitionsNodeBuilder).withValue(arg_0));
        return Node.objectNodeBuilder().withMember(VERSION, (ToNode)Node.from((String)this.version)).withMember(PARTITIONS, (ToNode)partitionsNodeBuilder.build()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partitions that = (Partitions)o;
        return this.version.equals(that.version) && this.partitions.equals(that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.partitions, this.sourceLocation);
    }

    public String toString() {
        return "Partitions{version='" + this.version + "', partitions=" + this.partitions + ", sourceLocation=" + this.sourceLocation + '}';
    }

    public static class Builder
    extends RulesComponentBuilder<Builder, Partitions> {
        private String version;
        private final BuilderRef<List<Partition>> partitions = BuilderRef.forList();

        public Builder(FromSourceLocation sourceLocation) {
            super(sourceLocation);
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder partitions(List<Partition> partitions) {
            this.partitions.clear();
            ((List)this.partitions.get()).addAll(partitions);
            return this;
        }

        public Builder addPartition(Partition p) {
            ((List)this.partitions.get()).add(p);
            return this;
        }

        public Partitions build() {
            return new Partitions(this);
        }
    }
}

