/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.rulesengine.aws.language.functions.EndpointAuthUtils;
import software.amazon.smithy.rulesengine.language.Endpoint;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Template;
import software.amazon.smithy.rulesengine.language.syntax.expressions.literal.Literal;
import software.amazon.smithy.rulesengine.traits.EndpointRuleSetTrait;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class EndpointSigV4Migration
extends AbstractDiffEvaluator {
    private static final Identifier ID_NAME = Identifier.of((String)"name");

    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Model oldModel = differences.getOldModel();
        ServiceIndex oldServiceIndex = ServiceIndex.of((Model)oldModel);
        Model newModel = differences.getNewModel();
        ServiceIndex newServiceIndex = ServiceIndex.of((Model)newModel);
        List serviceChanges = differences.changedShapes(ServiceShape.class).collect(Collectors.toList());
        for (ChangedShape change : serviceChanges) {
            ServiceShape oldServiceShape = (ServiceShape)change.getOldShape();
            ServiceShape newServiceShape = (ServiceShape)change.getNewShape();
            if (!oldServiceShape.hasTrait(EndpointRuleSetTrait.ID) || !newServiceShape.hasTrait(EndpointRuleSetTrait.ID)) continue;
            Optional endpointRuleSetOpt = change.getChangedTrait(EndpointRuleSetTrait.class);
            Optional authOpt = change.getChangedTrait(AuthTrait.class);
            List<String> oldModeledAuthSchemes = EndpointSigV4Migration.getModeledAuthSchemes(oldServiceIndex, oldServiceShape);
            List<String> newModeledAuthSchemes = EndpointSigV4Migration.getModeledAuthSchemes(newServiceIndex, newServiceShape);
            if (!endpointRuleSetOpt.isPresent() && !authOpt.isPresent() && oldModeledAuthSchemes.equals(newModeledAuthSchemes)) continue;
            EndpointRuleSetTrait oldErs = (EndpointRuleSetTrait)oldServiceShape.expectTrait(EndpointRuleSetTrait.class);
            Map oldEndpoints = EndpointRuleSet.EndpointPathCollector.from((EndpointRuleSetTrait)oldErs).collect();
            EndpointRuleSetTrait newErs = (EndpointRuleSetTrait)newServiceShape.expectTrait(EndpointRuleSetTrait.class);
            Map newEndpoints = EndpointRuleSet.EndpointPathCollector.from((EndpointRuleSetTrait)newErs).collect();
            Map<String, Pair> changedEndpoints = newEndpoints.entrySet().stream().filter(e -> oldEndpoints.containsKey(e.getKey())).map(e -> new AbstractMap.SimpleEntry<String, Pair>((String)e.getKey(), Pair.of((Object)((Endpoint)oldEndpoints.get(e.getKey())), (Object)((Endpoint)e.getValue())))).filter(e -> !((Endpoint)((Pair)e.getValue()).getLeft()).equals(((Pair)e.getValue()).getRight())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry<String, Pair> entry : changedEndpoints.entrySet()) {
                int sigV4aIndex;
                int sigV4Index;
                boolean isSigV4AAdded;
                String jsonPath = entry.getKey();
                Endpoint oldEndpoint = (Endpoint)entry.getValue().getLeft();
                Endpoint newEndpoint = (Endpoint)entry.getValue().getRight();
                List<String> oldAuthSchemes = EndpointSigV4Migration.getAuthSchemes(oldEndpoint, oldModeledAuthSchemes);
                List<String> newAuthSchemes = EndpointSigV4Migration.getAuthSchemes(newEndpoint, newModeledAuthSchemes);
                boolean isOldSigV4Present = EndpointSigV4Migration.containsSigV4EquivalentAuthScheme(oldAuthSchemes);
                boolean isOldSigV4APresent = EndpointSigV4Migration.containsSigV4AEquivalentAuthScheme(oldAuthSchemes);
                boolean isNewSigV4Present = EndpointSigV4Migration.containsSigV4EquivalentAuthScheme(newAuthSchemes);
                boolean isNewSigV4APresent = EndpointSigV4Migration.containsSigV4AEquivalentAuthScheme(newAuthSchemes);
                boolean isSigV4Replaced = isOldSigV4Present && !isNewSigV4Present && !isOldSigV4APresent && isNewSigV4APresent;
                boolean isSigV4AReplaced = !isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && !isNewSigV4APresent;
                boolean noSigV4XRemoved = isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && isNewSigV4APresent;
                boolean isSigV4Added = !isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && isNewSigV4APresent;
                boolean bl = isSigV4AAdded = isOldSigV4Present && isNewSigV4Present && !isOldSigV4APresent && isNewSigV4APresent;
                if (isSigV4Replaced) {
                    events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4` authentication scheme was replaced by the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Replacing the `aws.auth#sigv4` authentication scheme with the `aws.auth#sigv4a` authentication scheme directly is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
                    continue;
                }
                if (isSigV4AReplaced) {
                    events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4a` authentication scheme was replaced by the `aws.auth#sigv4` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Replacing the `aws.auth#sigv4` authentication scheme with the `aws.auth#sigv4a` authentication scheme directly may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
                    continue;
                }
                if (noSigV4XRemoved) {
                    boolean isSigV4BeforeSigV4A;
                    int oldSigV4Index = EndpointSigV4Migration.getIndexOfSigV4AuthScheme(oldAuthSchemes);
                    int oldSigV4aIndex = EndpointSigV4Migration.getIndexOfSigV4AAuthScheme(oldAuthSchemes);
                    int sigV4Index2 = EndpointSigV4Migration.getIndexOfSigV4AuthScheme(newAuthSchemes);
                    int sigV4aIndex2 = EndpointSigV4Migration.getIndexOfSigV4AAuthScheme(newAuthSchemes);
                    boolean isOldSigV4BeforeSigV4A = oldSigV4Index < oldSigV4aIndex;
                    boolean bl2 = isSigV4BeforeSigV4A = sigV4Index2 < sigV4aIndex2;
                    if (isOldSigV4BeforeSigV4A && !isSigV4BeforeSigV4A) {
                        events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4a` authentication scheme was moved before the `aws.auth#sigv4` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Moving the `aws.auth#sigv4a` authentication scheme before the `aws.auth#sigv4` authentication scheme is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
                    }
                    if (isOldSigV4BeforeSigV4A || !isSigV4BeforeSigV4A) continue;
                    events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4` authentication scheme was moved before the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Moving the `aws.auth#sigv4` authentication scheme before the `aws.auth#sigv4a` authentication scheme may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
                    continue;
                }
                if (isSigV4Added) {
                    sigV4Index = EndpointSigV4Migration.getIndexOfSigV4AuthScheme(newAuthSchemes);
                    boolean isSigV4AddedBeforeSigV4A = sigV4Index < (sigV4aIndex = EndpointSigV4Migration.getIndexOfSigV4AAuthScheme(newAuthSchemes));
                    if (!isSigV4AddedBeforeSigV4A) continue;
                    events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4` authentication scheme was added before the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Adding the `aws.auth#sigv4` authentication scheme before an existing `aws.auth#sigv4a` authentication scheme may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
                    continue;
                }
                if (!isSigV4AAdded) continue;
                sigV4Index = EndpointSigV4Migration.getIndexOfSigV4AuthScheme(newAuthSchemes);
                sigV4aIndex = EndpointSigV4Migration.getIndexOfSigV4AAuthScheme(newAuthSchemes);
                boolean isSigV4AAddedBeforeSigV4 = sigV4aIndex < sigV4Index;
                if (!isSigV4AAddedBeforeSigV4) continue;
                events.add(this.danger((Shape)newServiceShape, "The `aws.auth#sigv4a` authentication scheme was added before the `aws.auth#sigv4` authentication scheme in the effective auth schemes for an endpoint in the `@smithy.rules#endpointRuleSet` trait applied to `" + newServiceShape.getId() + "` at: `" + jsonPath + "`. Adding the `aws.auth#sigv4a` authentication scheme before an existing `aws.auth#sigv4` authentication scheme is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
            }
        }
        return events;
    }

    private static List<String> getAuthSchemes(Endpoint endpoint, List<String> modeledAuthSchemes) {
        List endpointAuthSchemes = endpoint.getEndpointAuthSchemes().stream().map(a -> ((Template)((Literal)a.get(ID_NAME)).asStringLiteral().get()).expectLiteral()).collect(Collectors.toList());
        return endpointAuthSchemes.size() == 0 ? modeledAuthSchemes : endpointAuthSchemes;
    }

    private static List<String> getModeledAuthSchemes(ServiceIndex serviceIndex, ServiceShape serviceShape) {
        return serviceIndex.getEffectiveAuthSchemes((ToShapeId)serviceShape).keySet().stream().map(ShapeId::toString).collect(Collectors.toList());
    }

    private static boolean containsSigV4EquivalentAuthScheme(List<String> authSchemes) {
        return EndpointSigV4Migration.getIndexOfSigV4AuthScheme(authSchemes) != -1;
    }

    private static boolean containsSigV4AEquivalentAuthScheme(List<String> authSchemes) {
        return EndpointSigV4Migration.getIndexOfSigV4AAuthScheme(authSchemes) != -1;
    }

    private static int getIndexOfSigV4AuthScheme(List<String> authSchemes) {
        return EndpointSigV4Migration.getIndexOfAuthScheme(authSchemes, EndpointAuthUtils::isSigV4EquivalentAuthScheme);
    }

    private static int getIndexOfSigV4AAuthScheme(List<String> authSchemes) {
        return EndpointSigV4Migration.getIndexOfAuthScheme(authSchemes, EndpointAuthUtils::isSigV4AEquivalentAuthScheme);
    }

    private static int getIndexOfAuthScheme(List<String> authSchemes, Predicate<String> identifier) {
        for (int i = 0; i < authSchemes.size(); ++i) {
            if (!identifier.test(authSchemes.get(i))) continue;
            return i;
        }
        return -1;
    }
}

