/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions.partition;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.rulesengine.language.RulesComponentBuilder;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class PartitionOutputs
implements ToSmithyBuilder<PartitionOutputs>,
FromSourceLocation,
ToNode {
    private static final String NAME = "name";
    private static final String DNS_SUFFIX = "dnsSuffix";
    private static final String DUAL_STACK_DNS_SUFFIX = "dualStackDnsSuffix";
    private static final String SUPPORTS_FIPS = "supportsFIPS";
    private static final String SUPPORTS_DUAL_STACK = "supportsDualStack";
    private static final String IMPLICIT_GLOBAL_REGION = "implicitGlobalRegion";
    private static final List<String> PROPERTIES = ListUtils.of((Object[])new String[]{"name", "dnsSuffix", "dualStackDnsSuffix", "supportsFIPS", "supportsDualStack", "implicitGlobalRegion"});
    private final String name;
    private final String dnsSuffix;
    private final String dualStackDnsSuffix;
    private final boolean supportsFips;
    private final boolean supportsDualStack;
    private final String implicitGlobalRegion;
    private final SourceLocation sourceLocation;

    private PartitionOutputs(Builder builder) {
        this.sourceLocation = builder.getSourceLocation();
        this.name = builder.name;
        this.dnsSuffix = builder.dnsSuffix;
        this.dualStackDnsSuffix = builder.dualStackDnsSuffix;
        this.supportsFips = builder.supportsFips;
        this.supportsDualStack = builder.supportsDualStack;
        this.implicitGlobalRegion = builder.implicitGlobalRegion;
    }

    public static Builder builder() {
        return new Builder((FromSourceLocation)SourceLocation.none());
    }

    public static PartitionOutputs fromNode(Node node) {
        Builder builder = new Builder((FromSourceLocation)node);
        ObjectNode objectNode = node.expectObjectNode();
        objectNode.expectNoAdditionalProperties(PROPERTIES);
        objectNode.getStringMember(NAME, builder::name);
        objectNode.getStringMember(DNS_SUFFIX, builder::dnsSuffix);
        objectNode.getStringMember(DUAL_STACK_DNS_SUFFIX, builder::dualStackDnsSuffix);
        objectNode.getBooleanMember(SUPPORTS_FIPS, builder::supportsFips);
        objectNode.getBooleanMember(SUPPORTS_DUAL_STACK, builder::supportsDualStack);
        objectNode.getStringMember(IMPLICIT_GLOBAL_REGION, builder::implicitGlobalRegion);
        return builder.build();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public String getDualStackDnsSuffix() {
        return this.dualStackDnsSuffix;
    }

    public boolean supportsFips() {
        return this.supportsFips;
    }

    public boolean supportsDualStack() {
        return this.supportsDualStack;
    }

    public String getImplicitGlobalRegion() {
        return this.implicitGlobalRegion;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new Builder((FromSourceLocation)this.getSourceLocation()).name(this.name).dnsSuffix(this.dnsSuffix).dualStackDnsSuffix(this.dualStackDnsSuffix).supportsFips(this.supportsFips).supportsDualStack(this.supportsDualStack).implicitGlobalRegion(this.implicitGlobalRegion);
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember(DNS_SUFFIX, this.dnsSuffix).withMember(DUAL_STACK_DNS_SUFFIX, this.dualStackDnsSuffix).withMember(SUPPORTS_FIPS, this.supportsFips).withMember(SUPPORTS_DUAL_STACK, this.supportsDualStack).withMember(IMPLICIT_GLOBAL_REGION, this.implicitGlobalRegion);
        if (this.name != null) {
            builder.withMember(NAME, this.name);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionOutputs partitionOutputs = (PartitionOutputs)o;
        return this.supportsFips == partitionOutputs.supportsFips && this.supportsDualStack == partitionOutputs.supportsDualStack && Objects.equals(this.name, partitionOutputs.name) && Objects.equals(this.dnsSuffix, partitionOutputs.dnsSuffix) && Objects.equals(this.dualStackDnsSuffix, partitionOutputs.dualStackDnsSuffix) && Objects.equals(this.implicitGlobalRegion, partitionOutputs.implicitGlobalRegion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dnsSuffix, this.dualStackDnsSuffix, this.supportsFips, this.supportsDualStack, this.implicitGlobalRegion);
    }

    public static class Builder
    extends RulesComponentBuilder<Builder, PartitionOutputs> {
        private String name;
        private String dnsSuffix;
        private String dualStackDnsSuffix;
        private boolean supportsFips;
        private boolean supportsDualStack;
        private String implicitGlobalRegion;

        public Builder(FromSourceLocation sourceLocation) {
            super(sourceLocation);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dnsSuffix(String dnsSuffix) {
            this.dnsSuffix = dnsSuffix;
            return this;
        }

        public Builder dualStackDnsSuffix(String dualStackDnsSuffix) {
            this.dualStackDnsSuffix = dualStackDnsSuffix;
            return this;
        }

        public Builder supportsFips(boolean supportsFips) {
            this.supportsFips = supportsFips;
            return this;
        }

        public Builder supportsDualStack(boolean supportsDualStack) {
            this.supportsDualStack = supportsDualStack;
            return this;
        }

        public Builder implicitGlobalRegion(String implicitGlobalRegion) {
            this.implicitGlobalRegion = implicitGlobalRegion;
            return this;
        }

        public PartitionOutputs build() {
            return new PartitionOutputs(this);
        }
    }
}

