/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PartitionEndpointSpecialCase
implements FromSourceLocation,
ToNode,
ToSmithyBuilder<PartitionEndpointSpecialCase> {
    private static final String ENDPOINT = "endpoint";
    private static final String REGION = "region";
    private static final String DUAL_STACK = "dualStack";
    private static final String FIPS = "fips";
    private final String endpoint;
    private final String region;
    private final Boolean dualStack;
    private final Boolean fips;
    private final SourceLocation sourceLocation;

    private PartitionEndpointSpecialCase(Builder builder) {
        this.endpoint = builder.endpoint;
        this.region = builder.region;
        this.dualStack = builder.dualStack;
        this.fips = builder.fips;
        this.sourceLocation = Objects.requireNonNull(builder.sourceLocation);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Boolean getDualStack() {
        return this.dualStack;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public String getRegion() {
        return this.region;
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withOptionalMember(ENDPOINT, Optional.ofNullable(this.endpoint).map(Node::from)).withOptionalMember(REGION, Optional.ofNullable(this.region).map(Node::from)).withOptionalMember(DUAL_STACK, Optional.ofNullable(this.dualStack).map(Node::from)).withOptionalMember(FIPS, Optional.ofNullable(this.fips).map(Node::from)).build();
    }

    public Builder toBuilder() {
        return new Builder().endpoint(this.endpoint).region(this.region).dualStack(this.dualStack).fips(this.fips).sourceLocation(this.sourceLocation);
    }

    public SourceLocation getSourceLocation() {
        return super.getSourceLocation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionEndpointSpecialCase that = (PartitionEndpointSpecialCase)o;
        return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.region, that.region) && Objects.equals(this.dualStack, that.dualStack) && Objects.equals(this.fips, that.fips);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.region, this.dualStack, this.fips);
    }

    public static PartitionEndpointSpecialCase fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        return PartitionEndpointSpecialCase.builder().sourceLocation(objectNode.getSourceLocation()).endpoint(objectNode.expectStringMember(ENDPOINT).getValue()).region(objectNode.expectStringMember(REGION).getValue()).dualStack(objectNode.getBooleanMemberOrDefault(DUAL_STACK, null)).fips(objectNode.getBooleanMemberOrDefault(FIPS, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<PartitionEndpointSpecialCase> {
        private String endpoint;
        private String region;
        private Boolean dualStack;
        private Boolean fips;
        private SourceLocation sourceLocation = SourceLocation.none();

        public PartitionEndpointSpecialCase build() {
            return new PartitionEndpointSpecialCase(this);
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder dualStack(Boolean dualStack) {
            this.dualStack = dualStack;
            return this;
        }

        public Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

