/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PartitionSpecialCase
implements FromSourceLocation,
ToNode,
ToSmithyBuilder<PartitionSpecialCase> {
    private static final String ENDPOINT = "endpoint";
    private static final String DUAL_STACK = "dualStack";
    private static final String FIPS = "fips";
    private final String endpoint;
    private final Boolean dualStack;
    private final Boolean fips;
    private final SourceLocation sourceLocation;

    private PartitionSpecialCase(Builder builder) {
        this.endpoint = builder.endpoint;
        this.dualStack = builder.dualStack;
        this.fips = builder.fips;
        this.sourceLocation = Objects.requireNonNull(builder.sourceLocation);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Boolean getDualStack() {
        return this.dualStack;
    }

    public Boolean getFips() {
        return this.fips;
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(ENDPOINT, this.endpoint).withOptionalMember(DUAL_STACK, Optional.ofNullable(this.dualStack).map(Node::from)).withOptionalMember(FIPS, Optional.ofNullable(this.fips).map(Node::from)).build();
    }

    public Builder toBuilder() {
        return new Builder().dualStack(this.dualStack).endpoint(this.endpoint).fips(this.fips).sourceLocation(this.sourceLocation);
    }

    public SourceLocation getSourceLocation() {
        return super.getSourceLocation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionSpecialCase that = (PartitionSpecialCase)o;
        return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.dualStack, that.dualStack) && Objects.equals(this.fips, that.fips);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.dualStack, this.fips);
    }

    public static PartitionSpecialCase fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        return PartitionSpecialCase.builder().sourceLocation(objectNode.getSourceLocation()).endpoint(objectNode.expectStringMember(ENDPOINT).getValue()).dualStack(objectNode.getBooleanMemberOrDefault(DUAL_STACK, null)).fips(objectNode.getBooleanMemberOrDefault(FIPS, null)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<PartitionSpecialCase> {
        private String endpoint;
        private Boolean dualStack;
        private Boolean fips;
        private SourceLocation sourceLocation = SourceLocation.none();

        public PartitionSpecialCase build() {
            return new PartitionSpecialCase(this);
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder dualStack(Boolean dualStack) {
            this.dualStack = dualStack;
            return this;
        }

        public Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }
    }
}

