/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.Partition;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.PartitionOutputs;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.Partitions;
import software.amazon.smithy.rulesengine.language.evaluation.type.Type;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.ToExpression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.ExpressionVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionDefinition;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionNode;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.LibraryFunction;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class AwsPartition
extends LibraryFunction {
    public static final String ID = "aws.partition";
    public static final Identifier NAME = Identifier.of((String)"name");
    public static final Identifier DNS_SUFFIX = Identifier.of((String)"dnsSuffix");
    public static final Identifier DUAL_STACK_DNS_SUFFIX = Identifier.of((String)"dualStackDnsSuffix");
    public static final Identifier SUPPORTS_FIPS = Identifier.of((String)"supportsFIPS");
    public static final Identifier SUPPORTS_DUAL_STACK = Identifier.of((String)"supportsDualStack");
    public static final Identifier IMPLICIT_GLOBAL_REGION = Identifier.of((String)"implicitGlobalRegion");
    public static final Identifier INFERRED = Identifier.of((String)"inferred");
    private static final Definition DEFINITION = new Definition();
    private static final List<Partition> PARTITIONS = new ArrayList<Partition>();
    private static final Map<String, Partition> REGION_MAP = new HashMap<String, Partition>();
    private static Partition AWS_PARTITION;

    private AwsPartition(FunctionNode functionNode) {
        super((FunctionDefinition)DEFINITION, functionNode);
    }

    @SmithyInternalApi
    public static void overridePartitions(Partitions partitions) {
        PARTITIONS.clear();
        PARTITIONS.addAll(partitions.getPartitions());
        AwsPartition.initializeRegionMap();
    }

    private static void initializeRegionMap() {
        REGION_MAP.clear();
        AWS_PARTITION = null;
        for (Partition partition : PARTITIONS) {
            if (partition.getId().equals("aws")) {
                AWS_PARTITION = partition;
            }
            for (String region : partition.getRegions().keySet()) {
                REGION_MAP.put(region, partition);
            }
        }
    }

    public static Definition getDefinition() {
        return DEFINITION;
    }

    public static AwsPartition ofExpressions(ToExpression arg1) {
        return DEFINITION.createFunction(FunctionNode.ofExpressions((String)ID, (ToExpression[])new ToExpression[]{arg1}));
    }

    public <T> T accept(ExpressionVisitor<T> visitor) {
        return (T)visitor.visitLibraryFunction((FunctionDefinition)DEFINITION, this.getArguments());
    }

    public static Partition findPartition(String regionName) {
        if (regionName == null) {
            return null;
        }
        Partition matchedPartition = REGION_MAP.get(regionName);
        if (matchedPartition != null) {
            return matchedPartition;
        }
        for (Partition partition : PARTITIONS) {
            if (!partition.getCompiledRegionRegex().matcher(regionName).matches()) continue;
            return partition;
        }
        return AWS_PARTITION;
    }

    static {
        PARTITIONS.addAll(Partitions.fromNode(Node.parse((InputStream)Partitions.class.getResourceAsStream("partitions.json"))).getPartitions());
        AwsPartition.initializeRegionMap();
    }

    public static final class Definition
    implements FunctionDefinition {
        private final Type returnType;

        private Definition() {
            LinkedHashMap<Identifier, Object> type = new LinkedHashMap<Identifier, Object>();
            type.put(NAME, Type.stringType());
            type.put(DNS_SUFFIX, Type.stringType());
            type.put(DUAL_STACK_DNS_SUFFIX, Type.stringType());
            type.put(SUPPORTS_DUAL_STACK, Type.booleanType());
            type.put(SUPPORTS_FIPS, Type.booleanType());
            type.put(IMPLICIT_GLOBAL_REGION, Type.stringType());
            this.returnType = Type.optionalType((Type)Type.recordType(type));
        }

        public String getId() {
            return AwsPartition.ID;
        }

        public List<Type> getArguments() {
            return Collections.singletonList(Type.stringType());
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Value evaluate(List<Value> arguments) {
            String regionName = arguments.get(0).expectStringValue().getValue();
            boolean inferred = false;
            Partition matchedPartition = (Partition)REGION_MAP.get(regionName);
            if (matchedPartition == null && (matchedPartition = AwsPartition.findPartition(regionName)) != null) {
                inferred = true;
            }
            if (matchedPartition == null) {
                throw new RuntimeException("Unable to match a partition for region " + regionName);
            }
            PartitionOutputs matchedPartitionOutputs = matchedPartition.getOutputs();
            return Value.recordValue((Map)MapUtils.of((Object)NAME, (Object)Value.stringValue((String)matchedPartition.getId()), (Object)DNS_SUFFIX, (Object)Value.stringValue((String)matchedPartitionOutputs.getDnsSuffix()), (Object)DUAL_STACK_DNS_SUFFIX, (Object)Value.stringValue((String)matchedPartitionOutputs.getDualStackDnsSuffix()), (Object)SUPPORTS_FIPS, (Object)Value.booleanValue((boolean)matchedPartitionOutputs.supportsFips()), (Object)SUPPORTS_DUAL_STACK, (Object)Value.booleanValue((boolean)matchedPartitionOutputs.supportsDualStack()), (Object)INFERRED, (Object)Value.booleanValue((boolean)inferred), (Object)IMPLICIT_GLOBAL_REGION, (Object)Value.stringValue((String)matchedPartitionOutputs.getImplicitGlobalRegion())));
        }

        public AwsPartition createFunction(FunctionNode functionNode) {
            return new AwsPartition(functionNode);
        }
    }
}

