/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions;

import java.util.Arrays;
import java.util.List;
import software.amazon.smithy.rulesengine.language.evaluation.type.Type;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.ToExpression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Expression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.ExpressionVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionDefinition;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionNode;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.LibraryFunction;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.ParseUrl;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class IsVirtualHostableS3Bucket
extends LibraryFunction {
    public static final String ID = "aws.isVirtualHostableS3Bucket";
    private static final Definition DEFINITION = new Definition();

    private IsVirtualHostableS3Bucket(FunctionNode functionNode) {
        super((FunctionDefinition)DEFINITION, functionNode);
    }

    public static Definition getDefinition() {
        return DEFINITION;
    }

    public static IsVirtualHostableS3Bucket ofExpressions(ToExpression arg1, ToExpression arg2) {
        return DEFINITION.createFunction(FunctionNode.ofExpressions((String)ID, (ToExpression[])new ToExpression[]{arg1, arg2}));
    }

    public static IsVirtualHostableS3Bucket ofExpressions(ToExpression arg1, boolean arg2) {
        return IsVirtualHostableS3Bucket.ofExpressions(arg1, (ToExpression)Expression.of((boolean)arg2));
    }

    public <T> T accept(ExpressionVisitor<T> visitor) {
        return (T)visitor.visitLibraryFunction((FunctionDefinition)DEFINITION, this.getArguments());
    }

    public static boolean isVirtualHostableBucket(String hostLabel, boolean allowDots) {
        int bucketLength;
        int n = bucketLength = hostLabel == null ? 0 : hostLabel.length();
        if (bucketLength < 3 || bucketLength > 63) {
            return false;
        }
        if (!IsVirtualHostableS3Bucket.isAlphanumeric(hostLabel.charAt(0)) || !IsVirtualHostableS3Bucket.isAlphanumeric(hostLabel.charAt(bucketLength - 1))) {
            return false;
        }
        if (!allowDots) {
            for (int i = 1; i < bucketLength - 1; ++i) {
                if (IsVirtualHostableS3Bucket.isValidBucketSegmentChar(hostLabel.charAt(i))) continue;
                return false;
            }
            return true;
        }
        char last = hostLabel.charAt(0);
        for (int i = 1; i < bucketLength; ++i) {
            char c = hostLabel.charAt(i);
            if (c == '.' ? last == '.' || last == '-' : (c == '-' ? last == '.' : !IsVirtualHostableS3Bucket.isAlphanumeric(c))) {
                return false;
            }
            last = c;
        }
        return !ParseUrl.isIpAddr((String)hostLabel);
    }

    private static boolean isAlphanumeric(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static boolean isValidBucketSegmentChar(char c) {
        return IsVirtualHostableS3Bucket.isAlphanumeric(c) || c == '-';
    }

    public static final class Definition
    implements FunctionDefinition {
        private Definition() {
        }

        public String getId() {
            return IsVirtualHostableS3Bucket.ID;
        }

        public List<Type> getArguments() {
            return Arrays.asList(Type.stringType(), Type.booleanType());
        }

        public Type getReturnType() {
            return Type.booleanType();
        }

        public Value evaluate(List<Value> arguments) {
            String hostLabel = arguments.get(0).expectStringValue().getValue();
            boolean allowDots = arguments.get(1).expectBooleanValue().getValue();
            return Value.booleanValue((boolean)IsVirtualHostableS3Bucket.isVirtualHostableBucket(hostLabel, allowDots));
        }

        public IsVirtualHostableS3Bucket createFunction(FunctionNode functionNode) {
            return new IsVirtualHostableS3Bucket(functionNode);
        }
    }
}

