/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.rulesengine.aws.language.functions.partition;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.PartitionOutputs;
import software.amazon.smithy.rulesengine.aws.language.functions.partition.RegionOverride;
import software.amazon.smithy.rulesengine.language.RulesComponentBuilder;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class Partition
implements ToSmithyBuilder<Partition>,
FromSourceLocation,
ToNode {
    private static final String ID = "id";
    private static final String REGION_REGEX = "regionRegex";
    private static final String REGIONS = "regions";
    private static final String OUTPUTS = "outputs";
    private static final List<String> PROPERTIES = ListUtils.of((Object[])new String[]{"id", "regionRegex", "regions", "outputs"});
    private final String id;
    private final String regionRegex;
    private final Map<String, RegionOverride> regions;
    private final PartitionOutputs outputs;
    private final SourceLocation sourceLocation;
    private Pattern compiledRegionRegex;

    private Partition(Builder builder) {
        this.sourceLocation = builder.getSourceLocation();
        this.id = builder.id;
        this.regionRegex = builder.regionRegex;
        this.regions = (Map)builder.regions.copy();
        this.outputs = builder.outputs;
    }

    public static Builder builder() {
        return new Builder((FromSourceLocation)SourceLocation.none());
    }

    public static Partition fromNode(Node node) {
        Builder builder = new Builder((FromSourceLocation)node);
        ObjectNode objectNode = node.expectObjectNode();
        objectNode.expectObjectNode().expectNoAdditionalProperties(PROPERTIES);
        objectNode.expectStringMember(ID, builder::id);
        objectNode.getStringMember(REGION_REGEX, builder::regionRegex);
        objectNode.getObjectMember(REGIONS, regionsNode -> regionsNode.getMembers().forEach((k, v) -> builder.putRegion(k.toString(), RegionOverride.fromNode(v))));
        objectNode.getObjectMember(OUTPUTS, outputsNode -> builder.outputs(PartitionOutputs.fromNode((Node)outputsNode)));
        return builder.build();
    }

    public String getId() {
        return this.id;
    }

    public String getRegionRegex() {
        return this.regionRegex;
    }

    public Pattern getCompiledRegionRegex() {
        Pattern result = this.compiledRegionRegex;
        if (result == null) {
            this.compiledRegionRegex = result = Pattern.compile(this.regionRegex);
        }
        return result;
    }

    public Map<String, RegionOverride> getRegions() {
        return this.regions;
    }

    public PartitionOutputs getOutputs() {
        return this.outputs;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new Builder((FromSourceLocation)this.getSourceLocation()).id(this.id).regionRegex(this.regionRegex).regions(this.regions).outputs(this.outputs);
    }

    public Node toNode() {
        ObjectNode.Builder regionNodeBuilder = ObjectNode.builder();
        for (Map.Entry<String, RegionOverride> entry : this.regions.entrySet()) {
            regionNodeBuilder.withMember(entry.getKey(), (ToNode)entry.getValue().toNode());
        }
        return Node.objectNodeBuilder().withMember(ID, (ToNode)Node.from((String)this.id)).withMember(REGION_REGEX, (ToNode)Node.from((String)this.regionRegex)).withMember(REGIONS, (ToNode)regionNodeBuilder.build()).withMember(OUTPUTS, (ToNode)this.outputs.toNode()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return Objects.equals(this.id, partition.id) && Objects.equals(this.regionRegex, partition.regionRegex) && Objects.equals(this.regions, partition.regions) && Objects.equals(this.outputs, partition.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.regionRegex, this.regions, this.outputs);
    }

    public static class Builder
    extends RulesComponentBuilder<Builder, Partition> {
        private String id;
        private String regionRegex;
        private final BuilderRef<Map<String, RegionOverride>> regions = BuilderRef.forOrderedMap();
        private PartitionOutputs outputs;

        public Builder(FromSourceLocation sourceLocation) {
            super(sourceLocation);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder regionRegex(String regionRegex) {
            this.regionRegex = regionRegex;
            return this;
        }

        public Builder regions(Map<String, RegionOverride> regions) {
            this.regions.clear();
            ((Map)this.regions.get()).putAll(regions);
            return this;
        }

        public Builder putRegion(String name, RegionOverride regionOverride) {
            ((Map)this.regions.get()).put(name, regionOverride);
            return this;
        }

        public Builder outputs(PartitionOutputs outputs) {
            this.outputs = outputs;
            return this;
        }

        public Partition build() {
            return new Partition(this);
        }
    }
}

