/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.aws.iam.traits.ActionResource;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ActionResources
implements ToNode,
ToSmithyBuilder<ActionResources> {
    private static final String REQUIRED = "required";
    private static final String OPTIONAL = "optional";
    private final Map<String, ActionResource> required;
    private final Map<String, ActionResource> optional;

    private ActionResources(Builder builder) {
        this.required = (Map)builder.required.copy();
        this.optional = (Map)builder.optional.copy();
    }

    public Map<String, ActionResource> getRequired() {
        return this.required;
    }

    public Map<String, ActionResource> getOptional() {
        return this.optional;
    }

    private static Builder builder() {
        return new Builder();
    }

    public static ActionResources fromNode(Node value) {
        Builder builder = ActionResources.builder();
        ObjectNode node = value.expectObjectNode().warnIfAdditionalProperties((Collection)ListUtils.of((Object)REQUIRED, (Object)OPTIONAL));
        if (node.containsMember(REQUIRED)) {
            for (Map.Entry entry : node.expectObjectMember(REQUIRED).getStringMap().entrySet()) {
                builder.putRequired((String)entry.getKey(), ActionResource.fromNode((Node)entry.getValue()));
            }
        }
        if (node.containsMember(OPTIONAL)) {
            for (Map.Entry entry : node.expectObjectMember(OPTIONAL).getStringMap().entrySet()) {
                builder.putOptional((String)entry.getKey(), ActionResource.fromNode((Node)entry.getValue()));
            }
        }
        return builder.build();
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!this.required.isEmpty()) {
            ObjectNode.Builder requiredBuilder = Node.objectNodeBuilder();
            for (Map.Entry<String, ActionResource> requiredEntry : this.required.entrySet()) {
                requiredBuilder.withMember(requiredEntry.getKey(), (ToNode)requiredEntry.getValue().toNode());
            }
        }
        if (!this.optional.isEmpty()) {
            ObjectNode.Builder optionalBuilder = Node.objectNodeBuilder();
            for (Map.Entry<String, ActionResource> optionalEntry : this.optional.entrySet()) {
                optionalBuilder.withMember(optionalEntry.getKey(), (ToNode)optionalEntry.getValue().toNode());
            }
        }
        return builder.build();
    }

    public SmithyBuilder<ActionResources> toBuilder() {
        return ActionResources.builder().required(this.required).optional(this.optional);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionResources that = (ActionResources)o;
        return Objects.equals(this.required, that.required) && Objects.equals(this.optional, that.optional);
    }

    public int hashCode() {
        return Objects.hash(this.required, this.optional);
    }

    public static final class Builder
    implements SmithyBuilder<ActionResources> {
        private final BuilderRef<Map<String, ActionResource>> required = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, ActionResource>> optional = BuilderRef.forOrderedMap();

        public ActionResources build() {
            return new ActionResources(this);
        }

        public Builder clearRequired() {
            ((Map)this.required.get()).clear();
            return this;
        }

        public Builder required(Map<String, ActionResource> required) {
            this.clearRequired();
            ((Map)this.required.get()).putAll(required);
            return this;
        }

        public Builder putRequired(String resourceName, ActionResource actionResource) {
            ((Map)this.required.get()).put(resourceName, actionResource);
            return this;
        }

        public Builder removeRequired(String resourceName) {
            ((Map)this.required.get()).remove(resourceName);
            return this;
        }

        public Builder clearOptional() {
            ((Map)this.optional.get()).clear();
            return this;
        }

        public Builder optional(Map<String, ActionResource> optional) {
            this.clearOptional();
            ((Map)this.optional.get()).putAll(optional);
            return this;
        }

        public Builder putOptional(String resourceName, ActionResource actionResource) {
            ((Map)this.optional.get()).put(resourceName, actionResource);
            return this;
        }

        public Builder removeOptional(String resourceName) {
            ((Map)this.optional.get()).remove(resourceName);
            return this;
        }
    }
}

