/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.List;
import java.util.Optional;
import software.amazon.smithy.aws.iam.traits.ActionNameTrait;
import software.amazon.smithy.aws.iam.traits.ActionPermissionDescriptionTrait;
import software.amazon.smithy.aws.iam.traits.ActionResources;
import software.amazon.smithy.aws.iam.traits.RequiredActionsTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IamActionTrait
extends AbstractTrait
implements ToSmithyBuilder<IamActionTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.iam#iamAction");
    private final String name;
    private final String documentation;
    private final String relativeDocumentation;
    private final List<String> requiredActions;
    private final ActionResources resources;
    private final List<String> createsResources;

    private IamActionTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.name = builder.name;
        this.documentation = builder.documentation;
        this.relativeDocumentation = builder.relativeDocumentation;
        this.requiredActions = (List)builder.requiredActions.copy();
        this.resources = builder.resources;
        this.createsResources = (List)builder.createsResources.copy();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public static String resolveActionName(OperationShape operation) {
        return operation.getTrait(IamActionTrait.class).flatMap(IamActionTrait::getName).orElseGet(() -> operation.getTrait(ActionNameTrait.class).map(StringTrait::getValue).orElseGet(() -> operation.getId().getName()));
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public static String resolveActionDocumentation(OperationShape operation) {
        return operation.getTrait(IamActionTrait.class).flatMap(IamActionTrait::getDocumentation).orElseGet(() -> operation.getTrait(ActionPermissionDescriptionTrait.class).map(StringTrait::getValue).orElseGet(() -> operation.getTrait(DocumentationTrait.class).map(StringTrait::getValue).orElse(null)));
    }

    public Optional<String> getRelativeDocumentation() {
        return Optional.ofNullable(this.relativeDocumentation);
    }

    public List<String> getRequiredActions() {
        return this.requiredActions;
    }

    public static List<String> resolveRequiredActions(OperationShape operation) {
        return operation.getTrait(IamActionTrait.class).map(IamActionTrait::getRequiredActions).filter(FunctionalUtils.not(List::isEmpty)).orElseGet(() -> operation.getTrait(RequiredActionsTrait.class).map(StringListTrait::getValues).orElse(ListUtils.of()));
    }

    public Optional<ActionResources> getResources() {
        return Optional.ofNullable(this.resources);
    }

    public List<String> getCreatesResources() {
        return this.createsResources;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Node createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IamActionTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public SmithyBuilder<IamActionTrait> toBuilder() {
        return ((Builder)IamActionTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).name(this.name);
    }

    public static final class Builder
    extends AbstractTraitBuilder<IamActionTrait, Builder> {
        private String name;
        private String documentation;
        private String relativeDocumentation;
        private final BuilderRef<List<String>> requiredActions = BuilderRef.forList();
        private ActionResources resources;
        private final BuilderRef<List<String>> createsResources = BuilderRef.forList();

        private Builder() {
        }

        public IamActionTrait build() {
            return new IamActionTrait(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder relativeDocumentation(String relativeDocumentation) {
            this.relativeDocumentation = relativeDocumentation;
            return this;
        }

        public Builder requiredActions(List<String> requiredActions) {
            this.clearRequiredActions();
            ((List)this.requiredActions.get()).addAll(requiredActions);
            return this;
        }

        public Builder clearRequiredActions() {
            ((List)this.requiredActions.get()).clear();
            return this;
        }

        public Builder addRequiredAction(String requiredAction) {
            ((List)this.requiredActions.get()).add(requiredAction);
            return this;
        }

        public Builder removeRequiredAction(String requiredAction) {
            ((List)this.requiredActions.get()).remove(requiredAction);
            return this;
        }

        public Builder resources(ActionResources resources) {
            this.resources = resources;
            return this;
        }

        public Builder createsResources(List<String> createsResources) {
            this.clearCreatesResources();
            ((List)this.createsResources.get()).addAll(createsResources);
            return this;
        }

        public Builder clearCreatesResources() {
            ((List)this.createsResources.get()).clear();
            return this;
        }

        public Builder addCreatesResource(String createsResource) {
            ((List)this.createsResources.get()).add(createsResource);
            return this;
        }

        public Builder removeCreatesResource(String createsResource) {
            ((List)this.createsResources.get()).remove(createsResource);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            IamActionTrait result = (IamActionTrait)((Object)new NodeMapper().deserialize(value, IamActionTrait.class));
            result.setNodeCache(value);
            return result;
        }
    }
}

