/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.aws.iam.traits.ConditionKeyDefinition;
import software.amazon.smithy.aws.iam.traits.ConditionKeysIndex;
import software.amazon.smithy.aws.iam.traits.DefineConditionKeysTrait;
import software.amazon.smithy.aws.iam.traits.ServiceResolvedConditionKeysTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;

public final class DefineConditionKeysTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ConditionKeysIndex conditionKeysIndex = ConditionKeysIndex.of(model);
        for (ServiceShape serviceShape : model.getServiceShapes()) {
            for (Map.Entry<String, ConditionKeyDefinition> conditionKeyEntry : conditionKeysIndex.getDefinedConditionKeys((ToShapeId)serviceShape).entrySet()) {
                List serviceResolvedKeys = serviceShape.getTrait(ServiceResolvedConditionKeysTrait.class).map(StringListTrait::getValues).orElse(ListUtils.of());
                if (!conditionKeyEntry.getValue().isRequired() || serviceResolvedKeys.contains(conditionKeyEntry.getKey())) continue;
                FromSourceLocation sourceLocation = (FromSourceLocation)serviceShape.getTrait(DefineConditionKeysTrait.class).map(FromSourceLocation::getSourceLocation).orElse(serviceShape.getSourceLocation());
                events.add(this.error((Shape)serviceShape, sourceLocation, String.format("The `%s` condition key is defined as required but is resolved from the request. This property is only valid for condition keys resolved by the service, it MUST also be specified in the `@serviceResolvedConditionKeys` trait or use the `@required` trait instead.", conditionKeyEntry.getKey())));
            }
        }
        return events;
    }
}

