/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IamResourceTrait
extends AbstractTrait
implements ToSmithyBuilder<IamResourceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.iam#iamResource");
    private final String name;
    private final String relativeDocumentation;
    private final boolean disableConditionKeyInheritance;

    private IamResourceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.name = builder.name;
        this.relativeDocumentation = builder.relativeDocumentation;
        this.disableConditionKeyInheritance = builder.disableConditionKeyInheritance;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public static String resolveResourceName(ResourceShape resource) {
        return resource.getTrait(IamResourceTrait.class).flatMap(IamResourceTrait::getName).orElse(resource.getId().getName());
    }

    public Optional<String> getRelativeDocumentation() {
        return Optional.ofNullable(this.relativeDocumentation);
    }

    public boolean isDisableConditionKeyInheritance() {
        return this.disableConditionKeyInheritance;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Node createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IamResourceTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public Builder toBuilder() {
        return ((Builder)IamResourceTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).name(this.name);
    }

    public static final class Builder
    extends AbstractTraitBuilder<IamResourceTrait, Builder> {
        private String name;
        private String relativeDocumentation;
        private boolean disableConditionKeyInheritance;

        private Builder() {
        }

        public IamResourceTrait build() {
            return new IamResourceTrait(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder relativeDocumentation(String relativeDocumentation) {
            this.relativeDocumentation = relativeDocumentation;
            return this;
        }

        public Builder disableConditionKeyInheritance(boolean disableConditionKeyInheritance) {
            this.disableConditionKeyInheritance = disableConditionKeyInheritance;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            IamResourceTrait result = (IamResourceTrait)((Object)new NodeMapper().deserialize(value, IamResourceTrait.class));
            result.setNodeCache(value);
            return result;
        }
    }
}

