/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.amazon.smithy.aws.iam.traits.IamResourceTrait;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public class IamResourceTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> results = new ArrayList<ValidationEvent>();
        for (ResourceShape resource : model.getResourceShapesWithTrait(IamResourceTrait.class)) {
            if (!resource.hasTrait(ArnTrait.class)) continue;
            String resourceName = ((IamResourceTrait)resource.expectTrait(IamResourceTrait.class)).getName().orElseGet(() -> StringUtils.lowerCase((String)resource.getId().getName()));
            ArnTrait arnTrait = (ArnTrait)resource.expectTrait(ArnTrait.class);
            List<String> arnComponents = this.parseArnComponents(arnTrait.getTemplate());
            if (arnComponents.contains(resourceName) || arnTrait.isAbsolute()) continue;
            results.add(this.danger((Shape)resource, String.format("The `@aws.iam#iamResource` trait applied to the resource defines an IAM resource name, `%s`, that does not match the `@arn` template, `%s`, of the resource.", resourceName, arnTrait.getTemplate())));
        }
        return results;
    }

    private List<String> parseArnComponents(String arnTemplate) {
        return Arrays.asList(arnTemplate.split("/"));
    }
}

