/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.iam.traits.ConditionKeyDefinition;
import software.amazon.smithy.aws.iam.traits.ConditionKeysTrait;
import software.amazon.smithy.aws.iam.traits.DefineConditionKeysTrait;
import software.amazon.smithy.aws.iam.traits.DisableConditionKeyInferenceTrait;
import software.amazon.smithy.aws.iam.traits.IamResourceTrait;
import software.amazon.smithy.aws.traits.ArnReferenceTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.StringUtils;

public final class ConditionKeysIndex
implements KnowledgeIndex {
    private static final String STRING_TYPE = "String";
    private static final String ARN_TYPE = "ARN";
    private final Map<ShapeId, Map<String, ConditionKeyDefinition>> serviceConditionKeys = new HashMap<ShapeId, Map<String, ConditionKeyDefinition>>();
    private final Map<ShapeId, Map<ShapeId, Set<String>>> resourceConditionKeys = new HashMap<ShapeId, Map<ShapeId, Set<String>>>();

    public ConditionKeysIndex(Model model) {
        for (ServiceShape service : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            String arnNamespace = ((ServiceTrait)service.expectTrait(ServiceTrait.class)).getArnNamespace();
            HashMap<String, ConditionKeyDefinition> serviceKeys = new HashMap<String, ConditionKeyDefinition>();
            if (service.hasTrait(DefineConditionKeysTrait.ID)) {
                DefineConditionKeysTrait trait = (DefineConditionKeysTrait)service.expectTrait(DefineConditionKeysTrait.class);
                for (Map.Entry<String, ConditionKeyDefinition> entry : trait.getConditionKeys().entrySet()) {
                    serviceKeys.put(ConditionKeysIndex.resolveFullConditionKey(service, entry.getKey()), entry.getValue());
                }
            }
            this.serviceConditionKeys.put(service.getId(), serviceKeys);
            this.resourceConditionKeys.put(service.getId(), new HashMap());
            for (ShapeId resourceId : service.getResources()) {
                this.compute(model, service, arnNamespace, model.expectShape(resourceId, ResourceShape.class), null);
            }
            for (ShapeId operationId : service.getOperations()) {
                this.compute(model, service, arnNamespace, model.expectShape(operationId, OperationShape.class), null);
            }
        }
    }

    public static ConditionKeysIndex of(Model model) {
        return (ConditionKeysIndex)model.getKnowledge(ConditionKeysIndex.class, ConditionKeysIndex::new);
    }

    static String resolveFullConditionKey(ServiceShape service, String conditionKey) {
        if (conditionKey.contains(":")) {
            return conditionKey;
        }
        return ((ServiceTrait)service.expectTrait(ServiceTrait.class)).getArnNamespace() + ":" + conditionKey;
    }

    public Map<String, ConditionKeyDefinition> getDefinedConditionKeys(ToShapeId service) {
        return Collections.unmodifiableMap(this.serviceConditionKeys.getOrDefault(service.toShapeId(), MapUtils.of()));
    }

    public Set<String> getConditionKeyNames(ToShapeId service) {
        if (!this.resourceConditionKeys.containsKey(service.toShapeId())) {
            return SetUtils.of();
        }
        HashSet<String> names = new HashSet<String>();
        for (Set<String> resourceKeyNames : this.resourceConditionKeys.get(service.toShapeId()).values()) {
            names.addAll(resourceKeyNames);
        }
        return names;
    }

    public Set<String> getConditionKeyNames(ToShapeId service, ToShapeId resourceOrOperation) {
        ShapeId serviceId = service.toShapeId();
        ShapeId subjectId = resourceOrOperation.toShapeId();
        return Collections.unmodifiableSet(this.resourceConditionKeys.getOrDefault(serviceId, MapUtils.of()).getOrDefault(subjectId, SetUtils.of()));
    }

    public Map<String, ConditionKeyDefinition> getDefinedConditionKeys(ToShapeId service, ToShapeId resourceOrOperation) {
        Map<String, ConditionKeyDefinition> serviceDefinitions = this.getDefinedConditionKeys(service);
        HashMap<String, ConditionKeyDefinition> definitions = new HashMap<String, ConditionKeyDefinition>();
        for (String name : this.getConditionKeyNames(service, resourceOrOperation)) {
            if (!serviceDefinitions.containsKey(name)) continue;
            definitions.put(name, serviceDefinitions.get(name));
        }
        return definitions;
    }

    private void compute(Model model, ServiceShape service, String arnRoot, Shape subject, ResourceShape parent) {
        this.compute(model, service, arnRoot, subject, parent, SetUtils.of());
    }

    private void compute(Model model, ServiceShape service, String arnRoot, Shape subject, ResourceShape parent, Set<String> parentDefinitions) {
        HashSet<String> definitions = new HashSet<String>();
        if (!subject.hasTrait(IamResourceTrait.ID) || !((IamResourceTrait)subject.expectTrait(IamResourceTrait.class)).isDisableConditionKeyInheritance()) {
            definitions.addAll(parentDefinitions);
        }
        this.resourceConditionKeys.get(service.getId()).put(subject.getId(), definitions);
        if (subject.hasTrait(ConditionKeysTrait.ID)) {
            definitions.addAll(((ConditionKeysTrait)subject.expectTrait(ConditionKeysTrait.class)).resolveConditionKeys(service));
        }
        subject.asResourceShape().ifPresent(resource -> {
            boolean disableConditionKeyInference = resource.hasTrait(DisableConditionKeyInferenceTrait.ID) || service.hasTrait(DisableConditionKeyInferenceTrait.ID);
            Map<String, String> childIdentifiers = !disableConditionKeyInference ? this.inferChildResourceIdentifiers(model, service.getId(), arnRoot, (ResourceShape)resource, parent) : MapUtils.of();
            for (ShapeId operationId : resource.getAllOperations()) {
                Optional operationOptional = model.getShape(operationId);
                if (!operationOptional.isPresent()) continue;
                this.compute(model, service, arnRoot, (Shape)operationOptional.get(), (ResourceShape)resource);
            }
            definitions.addAll(childIdentifiers.values());
            for (ShapeId resourceId : resource.getResources()) {
                Optional resourceOptional = model.getShape(resourceId);
                if (!resourceOptional.isPresent()) continue;
                this.compute(model, service, arnRoot, (Shape)resourceOptional.get(), (ResourceShape)resource, (Set<String>)definitions);
            }
        });
    }

    private Map<String, String> inferChildResourceIdentifiers(Model model, ShapeId service, String arnRoot, ResourceShape resource, ResourceShape parent) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set parentIds = parent == null ? SetUtils.of() : parent.getIdentifiers().keySet();
        HashSet childIds = new HashSet(resource.getIdentifiers().keySet());
        childIds.removeAll(parentIds);
        for (String childId : childIds) {
            model.getShape((ShapeId)resource.getIdentifiers().get(childId)).ifPresent(shape -> {
                ConditionKeyDefinition.Builder builder = ConditionKeyDefinition.builder();
                if (shape.hasTrait(ArnReferenceTrait.ID)) {
                    builder.type(ARN_TYPE);
                } else {
                    builder.type(STRING_TYPE);
                }
                builder.documentation(shape.getTrait(DocumentationTrait.class).map(StringTrait::getValue).orElse(ConditionKeysIndex.computeIdentifierDocs(resource, childId)));
                String computeIdentifierName = ConditionKeysIndex.computeIdentifierName(arnRoot, resource, childId);
                result.put(childId, computeIdentifierName);
                this.serviceConditionKeys.get(service).put(computeIdentifierName, builder.build());
            });
        }
        return result;
    }

    private static String computeIdentifierDocs(ResourceShape resource, String identifierName) {
        return ConditionKeysIndex.getContextKeyResourceName(resource) + " resource " + identifierName + " identifier";
    }

    private static String computeIdentifierName(String arnRoot, ResourceShape resource, String identifierName) {
        return arnRoot + ":" + ConditionKeysIndex.getContextKeyResourceName(resource) + StringUtils.capitalize((String)identifierName);
    }

    private static String getContextKeyResourceName(ResourceShape resource) {
        return resource.getTrait(IamResourceTrait.class).flatMap(IamResourceTrait::getName).orElse(resource.getId().getName());
    }
}

