/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ServiceTaggingValidator
extends AbstractValidator {
    private static final String TAG_RESOURCE_OPNAME = "TagResource";
    private static final String UNTAG_RESOURCE_OPNAME = "UntagResource";
    private static final String LISTTAGS_OPNAME = "ListTagsForResource";

    public List<ValidationEvent> validate(Model model) {
        AwsTagIndex awsTagIndex = AwsTagIndex.of(model);
        LinkedList<ValidationEvent> events = new LinkedList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            events.addAll(this.validateService(model, service, awsTagIndex));
        }
        return events;
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service, AwsTagIndex awsTagIndex) {
        Optional<ShapeId> listTagResourceId;
        Optional<ShapeId> untagResourceId;
        LinkedList<ValidationEvent> events = new LinkedList<ValidationEvent>();
        SourceLocation tagEnabledTraitLoc = ((TagEnabledTrait)service.expectTrait(TagEnabledTrait.class)).getSourceLocation();
        Optional<ShapeId> tagResourceId = awsTagIndex.getTagResourceOperation(service.getId());
        if (tagResourceId.isPresent()) {
            if (!awsTagIndex.serviceHasValidTagResourceOperation(service.getId())) {
                events.add(this.getMessageUnqualifedOperation(service, tagEnabledTraitLoc, tagResourceId.get(), TAG_RESOURCE_OPNAME));
            }
        } else {
            events.add(this.getMessageMissingOperation(service, tagEnabledTraitLoc, TAG_RESOURCE_OPNAME));
        }
        if ((untagResourceId = awsTagIndex.getUntagResourceOperation(service.getId())).isPresent()) {
            if (!awsTagIndex.serviceHasValidUntagResourceOperation(service.getId())) {
                events.add(this.getMessageUnqualifedOperation(service, tagEnabledTraitLoc, untagResourceId.get(), UNTAG_RESOURCE_OPNAME));
            }
        } else {
            events.add(this.getMessageMissingOperation(service, tagEnabledTraitLoc, UNTAG_RESOURCE_OPNAME));
        }
        if ((listTagResourceId = awsTagIndex.getListTagsForResourceOperation(service.getId())).isPresent()) {
            if (!awsTagIndex.serviceHasValidListTagsForResourceOperation(service.getId())) {
                events.add(this.getMessageUnqualifedOperation(service, tagEnabledTraitLoc, listTagResourceId.get(), LISTTAGS_OPNAME));
            }
        } else {
            events.add(this.getMessageMissingOperation(service, tagEnabledTraitLoc, LISTTAGS_OPNAME));
        }
        return events;
    }

    private ValidationEvent getMessageMissingOperation(ServiceShape service, SourceLocation location, String opName) {
        return this.warning((Shape)service, (FromSourceLocation)location, "Service marked `aws.api#TagEnabled` is missing an operation named '" + opName + ".'");
    }

    private ValidationEvent getMessageUnqualifedOperation(ServiceShape service, SourceLocation location, ShapeId opId, String opName) {
        return this.danger((Shape)service, (FromSourceLocation)location, String.format("Shape `%s` does not satisfy '%s' operation requirements.", opId.toString(), opName));
    }
}

