/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.StructureShape;

public final class ClientEndpointDiscoveryInfo {
    private final ServiceShape service;
    private final OperationShape operation;
    private final OperationShape discoveryOperation;
    private final StructureShape error;
    private final List<MemberShape> discoveryIds;
    private final boolean required;

    ClientEndpointDiscoveryInfo(ServiceShape service, OperationShape operation, OperationShape discoveryOperation, StructureShape error, List<MemberShape> discoveryIds, boolean required) {
        this.service = service;
        this.operation = operation;
        this.discoveryOperation = discoveryOperation;
        this.error = error;
        this.discoveryIds = discoveryIds;
        this.required = required;
    }

    public ServiceShape getService() {
        return this.service;
    }

    public OperationShape getOperation() {
        return this.operation;
    }

    public OperationShape getDiscoveryOperation() {
        return this.discoveryOperation;
    }

    @Deprecated
    public StructureShape getError() {
        return this.error;
    }

    public Optional<StructureShape> getOptionalError() {
        return Optional.ofNullable(this.error);
    }

    public List<MemberShape> getDiscoveryIds() {
        return this.discoveryIds;
    }

    public boolean isRequired() {
        return this.required;
    }
}

