/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.protocols;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class AwsQueryErrorTrait
extends AbstractTrait
implements ToSmithyBuilder<AwsQueryErrorTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.protocols#awsQueryError");
    private final String code;
    private final int httpResponseCode;

    public AwsQueryErrorTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.code = (String)SmithyBuilder.requiredState((String)"code", (Object)builder.code);
        this.httpResponseCode = (Integer)SmithyBuilder.requiredState((String)"httpResponseCode", (Object)builder.httpResponseCode);
    }

    public String getCode() {
        return this.code;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withMember("code", this.getCode()).withMember("httpResponseCode", (Number)this.getHttpResponseCode());
    }

    public SmithyBuilder<AwsQueryErrorTrait> toBuilder() {
        return AwsQueryErrorTrait.builder().code(this.code).httpResponseCode(this.httpResponseCode).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<AwsQueryErrorTrait, Builder> {
        private String code;
        private int httpResponseCode;

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder httpResponseCode(int httpResponseCode) {
            this.httpResponseCode = httpResponseCode;
            return this;
        }

        public AwsQueryErrorTrait build() {
            return new AwsQueryErrorTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)AwsQueryErrorTrait.builder().sourceLocation((FromSourceLocation)value);
            ObjectNode objectNode = value.expectObjectNode();
            builder.code(objectNode.expectStringMember("code").getValue());
            builder.httpResponseCode(objectNode.expectNumberMember("httpResponseCode").getValue().intValue());
            AwsQueryErrorTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

