/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.aws.traits.tagging.TaggableApiConfig;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TaggableResourceValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        AwsTagIndex tagIndex = AwsTagIndex.of(model);
        for (ServiceShape service : model.getServiceShapes()) {
            for (ResourceShape resource : topDownIndex.getContainedResources((ToShapeId)service)) {
                boolean resourceLikelyTaggable = false;
                if (resource.hasTrait(TaggableTrait.class)) {
                    events.addAll(this.validateResource(model, resource, service, tagIndex));
                    resourceLikelyTaggable = true;
                } else if (resource.hasTrait(ArnTrait.class) && tagIndex.serviceHasTagApis((ToShapeId)service)) {
                    events.add(this.warning((Shape)resource, "Resource is likely missing `aws.api#taggable` trait."));
                    resourceLikelyTaggable = true;
                }
                if (!resourceLikelyTaggable || service.hasTrait(TagEnabledTrait.class)) continue;
                events.add(this.warning((Shape)service, "Service has resources with `aws.api#taggable` applied but does not have the `aws.api#tagEnabled` trait."));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateResource(Model model, ResourceShape resource, ServiceShape service, AwsTagIndex awsTagIndex) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (awsTagIndex.isResourceTagOnUpdate((ToShapeId)resource.getId())) {
            Shape operation = resource.getUpdate().isPresent() ? model.expectShape((ShapeId)resource.getUpdate().get()) : model.expectShape((ShapeId)resource.getPut().get());
            events.add(this.danger(operation, "Update and put resource lifecycle operations should not support updating tags because it is a privileged operation that modifies access."));
        }
        boolean isServiceWideTaggable = awsTagIndex.serviceHasTagApis((ToShapeId)service.getId());
        boolean isInstanceOpTaggable = this.isTaggableViaInstanceOperations(model, resource);
        if (isServiceWideTaggable && !isInstanceOpTaggable && !resource.hasTrait(ArnTrait.class)) {
            events.add(this.error((Shape)resource, "Resource is taggable only via service-wide tag operations. It must use the `aws.api@arn` trait."));
        }
        if (!isServiceWideTaggable && !isInstanceOpTaggable) {
            events.add(this.error((Shape)resource, String.format("Resource does not have tagging CRUD operations and is not compatible with service-wide tagging operations for service `%s`.", service.getId())));
        }
        return events;
    }

    private Optional<OperationShape> resolveTagOperation(ShapeId tagApiId, Model model) {
        return model.getShape(tagApiId).flatMap(Shape::asOperationShape);
    }

    private boolean isTaggableViaInstanceOperations(Model model, ResourceShape resource) {
        TaggableTrait taggableTrait = (TaggableTrait)resource.expectTrait(TaggableTrait.class);
        if (taggableTrait.getApiConfig().isPresent()) {
            Optional<OperationShape> listTagsApi;
            Optional<OperationShape> untagApi;
            TaggableApiConfig apiConfig = taggableTrait.getApiConfig().get();
            boolean tagApiVerified = false;
            boolean untagApiVerified = false;
            boolean listTagsApiVerified = false;
            Optional<OperationShape> tagApi = this.resolveTagOperation(apiConfig.getTagApi(), model);
            if (tagApi.isPresent()) {
                boolean bl = tagApiVerified = TaggingShapeUtils.isTagPropertyInInput(Optional.of(tagApi.get().getId()), model, resource) && this.verifyTagApi(tagApi.get(), model);
            }
            if ((untagApi = this.resolveTagOperation(apiConfig.getUntagApi(), model)).isPresent()) {
                untagApiVerified = this.verifyUntagApi(untagApi.get(), model);
            }
            if ((listTagsApi = this.resolveTagOperation(apiConfig.getListTagsApi(), model)).isPresent()) {
                listTagsApiVerified = this.verifyListTagsApi(listTagsApi.get(), model);
            }
            return tagApiVerified && untagApiVerified && listTagsApiVerified;
        }
        return false;
    }

    private boolean verifyListTagsApi(OperationShape listTagsApi, Model model) {
        return this.exactlyOne(this.collectMemberTargetShapes(listTagsApi.getOutputShape(), model), memberEntry -> TaggingShapeUtils.isTagDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagsShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean verifyUntagApi(OperationShape untagApi, Model model) {
        return this.exactlyOne(this.collectMemberTargetShapes(untagApi.getInputShape(), model), memberEntry -> TaggingShapeUtils.isTagKeysDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagKeysShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean verifyTagApi(OperationShape tagApi, Model model) {
        return this.exactlyOne(this.collectMemberTargetShapes(tagApi.getInputShape(), model), memberEntry -> TaggingShapeUtils.isTagDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagsShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean exactlyOne(Collection<Map.Entry<MemberShape, Shape>> collection, Predicate<Map.Entry<MemberShape, Shape>> test) {
        int count = 0;
        for (Map.Entry<MemberShape, Shape> entry : collection) {
            if (!test.test(entry)) continue;
            ++count;
        }
        return count == 1;
    }

    private Collection<Map.Entry<MemberShape, Shape>> collectMemberTargetShapes(ShapeId ioShapeId, Model model) {
        ArrayList<Map.Entry<MemberShape, Shape>> collection = new ArrayList<Map.Entry<MemberShape, Shape>>();
        for (MemberShape memberShape : model.expectShape(ioShapeId).members()) {
            collection.add(new AbstractMap.SimpleImmutableEntry<MemberShape, Shape>(memberShape, model.expectShape(memberShape.getTarget())));
        }
        return collection;
    }
}

