/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.aws.traits.tagging.TaggableApiConfig;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.NoReplaceTrait;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class AwsTagIndex
implements KnowledgeIndex {
    private final Map<ShapeId, MemberShape> operationTagMembers = new HashMap<ShapeId, MemberShape>();
    private final Set<ShapeId> servicesWithAllTagOperations = new HashSet<ShapeId>();
    private final Set<ShapeId> resourceIsTagOnCreate = new HashSet<ShapeId>();
    private final Set<ShapeId> resourceIsTagOnUpdate = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToTagOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceTagOperationIsValid = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToUntagOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceUntagOperationIsValid = new HashSet<ShapeId>();
    private final Map<ShapeId, ShapeId> shapeToListTagsOperation = new HashMap<ShapeId, ShapeId>();
    private final Set<ShapeId> serviceListTagsOperationIsValid = new HashSet<ShapeId>();

    private AwsTagIndex(Model model) {
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            this.computeTaggingApis(model, service);
            if (!this.serviceTagOperationIsValid.contains(service.getId()) || !this.serviceUntagOperationIsValid.contains(service.getId()) || !this.serviceListTagsOperationIsValid.contains(service.getId())) continue;
            this.servicesWithAllTagOperations.add(service.getId());
        }
        for (ResourceShape resource : model.getResourceShapesWithTrait(TaggableTrait.class)) {
            if (!((TaggableTrait)resource.expectTrait(TaggableTrait.class)).getProperty().isPresent()) continue;
            this.computeResourceTagLocations(model, resource);
        }
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        for (OperationShape operation : model.getOperationShapes()) {
            for (MemberShape memberShape : operationIndex.getInputMembers((ToShapeId)operation).values()) {
                if (!TaggingShapeUtils.isTagDesiredName(memberShape.getMemberName())) continue;
                this.operationTagMembers.put(operation.getId(), memberShape);
            }
        }
    }

    public static AwsTagIndex of(Model model) {
        return (AwsTagIndex)model.getKnowledge(AwsTagIndex.class, AwsTagIndex::new);
    }

    public Optional<MemberShape> getTagsMember(ToShapeId operation) {
        return Optional.ofNullable(this.operationTagMembers.get(operation.toShapeId()));
    }

    public boolean isResourceTagOnCreate(ToShapeId resourceId) {
        return this.resourceIsTagOnCreate.contains(resourceId.toShapeId());
    }

    public boolean isResourceTagOnUpdate(ToShapeId resourceId) {
        return this.resourceIsTagOnUpdate.contains(resourceId.toShapeId());
    }

    public boolean serviceHasTagApis(ToShapeId serviceShapeId) {
        return this.servicesWithAllTagOperations.contains(serviceShapeId.toShapeId());
    }

    public Optional<ShapeId> getTagResourceOperation(ToShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToTagOperation.get(serviceOrResourceId.toShapeId()));
    }

    public Optional<ShapeId> getUntagResourceOperation(ToShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToUntagOperation.get(serviceOrResourceId.toShapeId()));
    }

    public Optional<ShapeId> getListTagsForResourceOperation(ToShapeId serviceOrResourceId) {
        return Optional.ofNullable(this.shapeToListTagsOperation.get(serviceOrResourceId.toShapeId()));
    }

    public boolean serviceHasValidTagResourceOperation(ToShapeId serviceId) {
        return this.serviceTagOperationIsValid.contains(serviceId.toShapeId());
    }

    public boolean serviceHasValidUntagResourceOperation(ToShapeId serviceId) {
        return this.serviceUntagOperationIsValid.contains(serviceId.toShapeId());
    }

    public boolean serviceHasValidListTagsForResourceOperation(ToShapeId serviceId) {
        return this.serviceListTagsOperationIsValid.contains(serviceId.toShapeId());
    }

    private void computeTaggingApis(Model model, ServiceShape service) {
        HashMap<String, ShapeId> operationMap = new HashMap<String, ShapeId>();
        for (ShapeId operationId : service.getOperations()) {
            operationMap.put(operationId.getName(), operationId);
        }
        this.calculateTagApi(model, service, operationMap);
        this.calculateUntagApi(model, service, operationMap);
        this.calculateListTagsApi(model, service, operationMap);
    }

    private void calculateTagApi(Model model, ServiceShape service, Map<String, ShapeId> operationMap) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        if (operationMap.containsKey("TagResource")) {
            ShapeId tagOperationId = operationMap.get("TagResource");
            this.shapeToTagOperation.put(service.getId(), tagOperationId);
            OperationShape tagOperation = (OperationShape)model.expectShape(tagOperationId, OperationShape.class);
            if (TaggingShapeUtils.verifyTagResourceOperation(model, tagOperation, operationIndex)) {
                this.serviceTagOperationIsValid.add(service.getId());
            }
        }
        for (ResourceShape resourceShape : topDownIndex.getContainedResources((ToShapeId)service)) {
            this.shapeToTagOperation.put(resourceShape.getId(), resourceShape.getTrait(TaggableTrait.class).flatMap(TaggableTrait::getApiConfig).map(TaggableApiConfig::getTagApi).orElse(this.shapeToTagOperation.get(service.getId())));
        }
    }

    private void calculateUntagApi(Model model, ServiceShape service, Map<String, ShapeId> operationMap) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        if (operationMap.containsKey("UntagResource")) {
            ShapeId untagOperationId = operationMap.get("UntagResource");
            this.shapeToUntagOperation.put(service.getId(), untagOperationId);
            OperationShape untagOperation = (OperationShape)model.expectShape(untagOperationId, OperationShape.class);
            if (TaggingShapeUtils.verifyUntagResourceOperation(model, untagOperation, operationIndex)) {
                this.serviceUntagOperationIsValid.add(service.getId());
            }
        }
        for (ResourceShape resourceShape : topDownIndex.getContainedResources((ToShapeId)service)) {
            this.shapeToUntagOperation.put(resourceShape.getId(), resourceShape.getTrait(TaggableTrait.class).flatMap(TaggableTrait::getApiConfig).map(TaggableApiConfig::getUntagApi).orElse(this.shapeToUntagOperation.get(service.getId())));
        }
    }

    private void calculateListTagsApi(Model model, ServiceShape service, Map<String, ShapeId> operationMap) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        if (operationMap.containsKey("ListTagsForResource")) {
            ShapeId listTagsOperationId = operationMap.get("ListTagsForResource");
            this.shapeToListTagsOperation.put(service.getId(), listTagsOperationId);
            OperationShape listTagsOperation = (OperationShape)model.expectShape(listTagsOperationId, OperationShape.class);
            if (TaggingShapeUtils.verifyListTagsOperation(model, listTagsOperation, operationIndex)) {
                this.serviceListTagsOperationIsValid.add(service.getId());
            }
        }
        for (ResourceShape resourceShape : topDownIndex.getContainedResources((ToShapeId)service)) {
            this.shapeToListTagsOperation.put(resourceShape.getId(), resourceShape.getTrait(TaggableTrait.class).flatMap(TaggableTrait::getApiConfig).map(TaggableApiConfig::getListTagsApi).orElse(this.shapeToListTagsOperation.get(service.getId())));
        }
    }

    private void computeResourceTagLocations(Model model, ResourceShape resource) {
        if (TaggingShapeUtils.isTagPropertyInInput(resource.getCreate(), model, resource)) {
            this.resourceIsTagOnCreate.add(resource.getId());
        }
        if (TaggingShapeUtils.isTagPropertyInInput(resource.getUpdate(), model, resource)) {
            this.resourceIsTagOnUpdate.add(resource.getId());
        }
        if (TaggingShapeUtils.isTagPropertyInInput(resource.getPut(), model, resource)) {
            this.resourceIsTagOnCreate.add(resource.getId());
            if (!resource.hasTrait(NoReplaceTrait.ID)) {
                this.resourceIsTagOnUpdate.add(resource.getId());
            }
        }
    }
}

